% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_params.r
\docType{class}
\name{NlmeEngineExtraParams-class}
\alias{NlmeEngineExtraParams-class}
\title{NlmeEngineExtraParams : Defines all engine parameters for NLME models
Wrapped up by \code{engineParams} function.}
\description{
NlmeEngineExtraParams : Defines all engine parameters for NLME models
Wrapped up by \code{engineParams} function.
}
\section{Slots}{

\describe{
\item{\code{isPopulation}}{logical; TRUE if the model is a population model, FALSE
for an individual model.}

\item{\code{sort}}{character; String to pass sorting options to the NLME engine.
Typically " -sort " to enable sorting or "" to disable it.}

\item{\code{csv}}{character; String to control CSV input options. Typically " -csv "
to strict the input data to comma-separated-values. Use "" to disable it
(NLME will try to guess the input format).}

\item{\code{method}}{numeric; Integer code specifying the estimation method.
\itemize{
  \item 1: QRPEM
  \item 2: IT2S-EM
  \item 3: FOCE-LB
  \item 4: FO
  \item 5: FOCE-ELS/LAPLACIAN (see below for choice between FOCE-ELS and LAPLACIAN)
  \item 6: NAIVE-POOLED
}
  The choice between FOCE-ELS and LAPLACIAN (when \code{method} is 5) depends
  on the \code{xfocehess} slot: \code{xfocehess = 1} selects FOCE-ELS, and
  \code{xfocehess = 0} selects LAPLACIAN.}

\item{\code{numIterations}}{numeric; The maximum number of iterations allowed for the
estimation algorithm.  Values must be non-negative integers.}

\item{\code{odeToUse}}{numeric; Integer code specifying the ODE solver to be used.
  Possible values are:
\itemize{
  \item 1: LSODE with numerical Jacobian
  \item 2: LSODE with analytical Jacobian
  \item 3: Runge-Kutta
  \item 4: LSODA with numerical Jacobian
  \item 5: LSODA with analytical Jacobian
  \item 6: Matrix Exponent
  \item 7: DOPRI5
}}

\item{\code{rtol}}{numeric; Specifies the relative tolerance for the ODE solver.}

\item{\code{atol}}{numeric; Specifies the absolute tolerance for the ODE solver.}

\item{\code{nmxstep}}{numeric; Specifies the maximum number of steps allowed for the
ODE solver.}

\item{\code{anagrad}}{numeric; Flag controlling the differentiation method used
during the optimization of random effects (etas). 0 uses a finite
difference approach, and 1 uses automatic differentiation where possible.}

\item{\code{xnp}}{numeric; Controls the use of non-parametric (NP) optimization.
\itemize{
  \item 0: No NP optimization.
  \item 1: NONMEM-style NP optimization using posthoc estimates as support points.
  \item >1: Evolutionary NP algorithm with \code{xnp} generations.
}}

\item{\code{xnorderagq}}{numeric; Specifies the number of quadrature points per
  dimension for Adaptive Gaussian Quadrature (AGQ). Only applicable when
  \code{method} is \code{FOCE-ELS} or \code{LAPLACIAN}.
\itemize{
  \item 1: Standard FOCE-ELS/LAPLACIAN computation (no AGQ).
  \item >1: AGQ is performed. The total number of quadrature points used is \code{(number of ETAs)^xnorderagq}.
}}

\item{\code{xfocehess}}{numeric; Determines the method for calculating the Hessian
  matrix when using FOCE methods.
\itemize{
  \item 0: Use numerical second derivatives.
  \item 1: Use the FOCE approximation.
}
  Applicable only when \code{method} is \code{FOCE-ELS} or \code{LAPLACIAN}.}

\item{\code{xstderr}}{numeric; Specifies the method for standard error estimation.
\itemize{
  \item 0: No standard error estimation.
  \item 1: Central difference method.
  \item 2: Forward difference method.
}}

\item{\code{sand}}{character; String to request sandwich standard error calculation.
Typically " -sand " or "".}

\item{\code{fisher}}{character; String to request Fisher score standard error
calculation. Typically " -fscore " or "".}

\item{\code{autodetect}}{character; String to request auto-detection of standard
error method. Typically " -AutoSE " or "".}

\item{\code{xlandig}}{numeric; Specifies the optimization accuracy (NDIGIT) for the
outer loop (thetas and sigmas) when using \code{FOCE-ELS} or
\code{LAPLACIAN} methods.}

\item{\code{xlatol}}{numeric; Specifies the relative step size used for numerical
computation of the Hessian matrix (second derivatives) during standard
error calculation.}

\item{\code{xblndig}}{numeric; Specifies the optimization accuracy (NDIGIT) for the
inner loop (optimization of etas).  Also applies to the single optimization
loop in the \code{NAIVE-POOLED} method.}

\item{\code{xbltol}}{numeric; Specifies the relative step size for numerical
differentiation during model linearization.}

\item{\code{gradTolOuter}}{Numeric maximum gradient tolerance in the outer
(Theta/Omega/Sigma) optimization loop. Applicable to \code{FOCE-ELS} and
\code{LAPLACIAN} methods.}

\item{\code{stepTolOuter}}{Numeric maximum step tolerance in the outer
(Theta/Omega/Sigma) optimization loop. Applicable to \code{FOCE-ELS} and
\code{LAPLACIAN} methods.}

\item{\code{gradTolInner}}{Numeric maximum gradient tolerance in the inner (Eta)
optimization loop. Applicable to \code{FOCE-ELS} and
\code{LAPLACIAN} methods.}

\item{\code{stepTolInner}}{Numeric maximum step tolerance in the inner (Eta)
optimization loop. Applicable to \code{FOCE-ELS} and
\code{LAPLACIAN} methods.}

\item{\code{refDeltaLagl}}{Numeric LL Delta tolerance value used during
Theta/Omega/Sigma optimization. Applicable to \code{FOCE-ELS} and
\code{LAPLACIAN} methods.}

\item{\code{isPCWRES}}{numeric; Flag indicating if Population Conditional Weighted
Residuals (PCWRES) should be computed.  A value of 1 indicates computation,
while 0 indicates no computation. Only applicable to population models.}

\item{\code{xpcwresnrep}}{numeric; Stores the number of simulation replicates used
for PCWRES computation.  Applicable only when \code{isPCWRES} is 1.}

\item{\code{xisample}}{numeric; Specifies the number of sample points used in the
QRPEM algorithm. Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{xmapassist}}{numeric; Controls the use of MAP assistance in the QRPEM
  algorithm.
\itemize{
  \item 0: No MAP assistance.
  \item >0: The inner ETAs optimization loop is used in the QRPEM outer
   optimization loop with a periodicity equal to the value of \code{xmapassist}.
}
  Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{xmapnp}}{numeric; Specifies the number of iterations for a preliminary
Naive-Pooled optimization run before the main estimation. Applicable when
the method is not \code{NAIVE-POOLED}.}

\item{\code{ximpsampdof}}{numeric; Controls the importance sampling distribution used
  in the QRPEM algorithm. Only applicable when \code{method} is \code{QRPEM}.
\itemize{
 \item 0: Multivariate Normal distribution.
 \item 1: Multivariate Double Exponential (Laplace) distribution.
 \item 2: Direct sampling from the prior.
 \item 3-30: Multivariate T distribution with degrees of freedom equal to the value of \code{ximpsampdof}.
 \item -2: Mixture-2 distribution.
 \item -3: Mixture-3 distribution.
}}

\item{\code{xmcpem}}{numeric; Controls the sampling method used in the QRPEM
  algorithm.
\itemize{
  \item 0: Quasi-Random sampling.
  \item 1: Monte-Carlo sampling.
}
  Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{xpemrunall}}{numeric; Set to \code{1} to execute all requested
iterations specified in \code{numIterations}. Only applicable to population
models with \code{method = "QRPEM"}.}

\item{\code{xsirsamp}}{numeric; Specifies the number of samples per eta per subject
used in the Sampling Importance Resampling (SIR) algorithm within QRPEM.
Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{xburnin}}{numeric; Specifies the number of burn-in iterations in the
QRPEM algorithm.  During burn-in, omegas can be frozen (see
\code{xnonomegaburn}). Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{xnonomegaburn}}{numeric; Controls whether omegas are frozen during the
  burn-in phase of the QRPEM algorithm.
\itemize{
  \item 0: burn-in with frozen omegas is off.
  \item 1: burn-in with frozen omegas is on.
}
  Only applicable when \code{method} is \code{QRPEM}. See also
  \code{xburnin}.}

\item{\code{xaccratio}}{numeric; Specifies the acceptance ratio used in the QRPEM
algorithm for scaling the covariance matrix. Only applicable when
\code{method} is \code{QRPEM}. Only applicable to population models with
\code{method = "QRPEM"}.}

\item{\code{xscramble}}{numeric; Specifies the scrambling method for quasi-random
  number generation in the QRPEM algorithm.
\itemize{
  \item 0: No scrambling.
  \item 1: Owen-type scrambling.
  \item 2: Faure-Tezuka scrambling.
}
  Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{emTolType}}{Numeric specifying QRPEM convergence check type:
\describe{
  \item{0}{Default (no rollout, LL & Thetas)}
  \item{1}{LL & Params with rollout}
  \item{2}{LL with rollout}
  \item{3}{Params with rollout}
}
Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{emConvLen}}{Numeric specifying the number of iterations to check for
convergence. Only applicable when \code{method} is \code{QRPEM}.}

\item{\code{emConvCritVal}}{Numeric specifying the convergence critical value. Only
applicable when \code{method} is \code{QRPEM}.}

\item{\code{pardern}}{numeric; Specifies the number of time steps used for outputting
partial derivatives of observed variables with respect to parameters. Only
applicable to individual models.}

\item{\code{parderd}}{numeric; Specifies the step size for numerical calculation of
partial derivatives of observed variables with respect to parameters. Only
applicable to individual models.}

\item{\code{logtran}}{numeric; Engine flag controlling log-transformation behavior
for single LogAdditive error model.}
}}

\examples{
param <- NlmeEngineExtraParams(
  method = 3,
  numIterations = 1000
)
param <- NlmeEngineExtraParams(
  method = 1,
  numIterations = 300
)
param <- NlmeEngineExtraParams(
  method = 1,
  numIterations = 300,
  isPopulation = TRUE,
  odeToUse = 2
)
}
\seealso{
[engineParams()]
}
\keyword{internal}
