% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlmeParallelHost.R
\name{print.NlmeParallelHost}
\alias{print.NlmeParallelHost}
\title{Print an NlmeParallelHost Object}
\usage{
\method{print}{NlmeParallelHost}(x, ...)
}
\arguments{
\item{x}{An \code{NlmeParallelHost} object to print.}

\item{...}{Additional arguments passed to the \code{print} function.}
}
\value{
\code{NULL}. This function is called for its side effect of printing
to the console.
}
\description{
Prints a summary of the configuration of an \code{NlmeParallelHost} object.
}
\examples{
host <- NlmeParallelHost(
  sharedDirectory = "~/shared/",
  installationDirectory = "~/nlme/",
  hostName = "my_host",
  machineName = "192.168.1.100",
  hostType = "RHEL",
  numCores = 8,
  isLocal = FALSE,
  rLocation = "/usr/bin/R",
  scriptPath = "/path/to/script.R",
  userAuthentication =
    NlmeUserAuthentication(userName = "myuser", userPassword = "mypassword"),
  parallelMethod = NlmeParallelMethod("SGE_MPI")
)

print(host)

}
\keyword{internal}
