% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_word3D.R
\name{plot_word3D}
\alias{plot_word3D}
\title{Plot the 3D fractal containing the chosen word}
\usage{
plot_word3D(
  word = "copula",
  R = 20,
  plot.rgl = TRUE,
  copula = TRUE,
  portion = 0.2,
  color.rgl.plot = "green2magenta",
  plot.surface = "Sphere",
  histogram = TRUE,
  shift = 1.2,
  orbit = 3000,
  cex.label = 0.7,
  size.lines = 0.1,
  Theta = 40,
  Phi = 30,
  Box = TRUE,
  projection = TRUE,
  letter_type = 1
)
}
\arguments{
\item{word}{Word which the fractal should contain infinitely often.}

\item{R}{Number of runs of the chaos game.}

\item{plot.rgl}{If \code{plot.rgl = TRUE} a rgl-plot is generated. Otherwise a scatter-plot with plot3D is produced.}

\item{copula}{logical. If TRUE the sample is (approximately) probability-integral-transformed.}

\item{portion}{Portion based on which the empirical distribution functions are calculated, if \code{copula = TRUE}.}

\item{color.rgl.plot}{Plotting color/color-range for the rgl-plot. One can choose between \code{"gray"}, \code{"blue2green"}, \code{"green2red"}, \code{"blue2yellow"}, \code{"ygobb"},  \code{"magenta2green"} and \code{"green2magenta"}.}

\item{plot.surface}{Three-dimensional surface on which the two-dimensional fractal is projected. Options are \code{"Sphere"}, \code{"Helix"}, \code{"Torus"}, \code{"EnneperMinimalSurface"} and \code{"CatalanSurface"}.}

\item{histogram}{It is an option available only under the rgl-plot option (i.e if \code{plot.rgl = TRUE}). If \code{histogram = TRUE}, two-dimensional and one-dimensional marginal histograms are plotted in the rgl-plot.}

\item{shift}{Distance between letters.}

\item{orbit}{Number of steps in each run of the chaos game.}

\item{cex.label}{Font size, for exporting as a pdf or png file (see examples).}

\item{size.lines}{Line width, for exporting as a pdf or png file (see examples).}

\item{Theta}{Angles defining the viewing direction. \code{Theta} gives the azimuthal direction and \code{Phi} the colatitude in the scatter-plot (see Package plot3D). Can be chosen only under the scatter-plot option (i.e if \code{plot.rgl = FALSE}).}

\item{Phi}{Angles defining the viewing direction. \code{Theta} gives the azimuthal direction and \code{Phi} the colatitude in the scatter-plot (see Package plot3D). Can be chosen only under the scatter-plot option (i.e if \code{plot.rgl = FALSE}).}

\item{Box}{If \code{TRUE}, axis, two-dimensional projections (if \code{projection = TRUE}) and marginal histograms are plotted.}

\item{projection}{An option available only if \code{Box = TRUE}. If \code{projection = TRUE}, the two-dimensional projections are plotted together with axis and marginal histograms.}

\item{letter_type}{integer, which indicates the type of the letters. Options are 1 (default) or 2 (round letters).}
}
\description{
The function allows to enter a word of at least two letters based on which an Iterated Function System with Probabilities (IFSP) is constructed.
This IFSP is then used to generate a two-dimensional fractal containing the chosen word infinitely often, which is then projected onto several three-dimensional surfaces.
Optionally, the projection is transformed into another fractal with uniform marginals.
}
\examples{
# function with a word as input, runs the chaos game,
# calculates the copula transformation and projects the result on a sphere:
# for nice results use, for example, R = 20 and orbit = 3000
# A <- plot_word3D(word = "copula", copula = FALSE, R = 50, orbit = 100)

# further examples:
# projection of the fractal on the Enneper Minimal Surface:
# A <- plot_word3D(word = "copula", R = 75, orbit = 300, copula = FALSE,
#                  plot.surface = "EnneperMinimalSurface", histogram = FALSE)
# same example as before, now with histogram = TRUE
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE,
#                  plot.surface = "EnneperMinimalSurface")
# same example as before (approximately) probability-integral-transformed  (i.e. copula = TRUE)
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = TRUE,
#                   plot.surface = "EnneperMinimalSurface")

# projection of the fractal on a Catalan Surface
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE,
#                  color.rgl.plot = "blue2green", plot.surface = "CatalanSurface")

# projection of the fractal on a Helix
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE,
#                  color.rgl.plot = "green2red", plot.surface = "Helix")

# projection of the fractal on a Torus
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE,
#                  color.rgl.plot = "blue2yellow", plot.surface = "Torus")

# projection of the fractal on a Sphere
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE,
#                  color.rgl.plot = "ygobb", plot.surface = "Sphere")
# Sphere (approximately) probability-integral-transformed (i.e. copula = TRUE)
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = TRUE,
#                  color.rgl.plot = "ygobb", plot.surface = "Sphere")

# scatter-plot with plot3D (i.e. plot.rgl = FALSE) for exporting as a pdf file
# pdf(file = "Sphere.pdf", width = 30, height = 25)
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE, plot.rgl = FALSE,
#                  plot.surface = "Sphere", cex.label = 1.8, size.lines = 0.001)
# dev.off()

#' # scatter-plot with plot3D (i.e. plot.rgl = FALSE) for exporting as a png file
# png(file = "Sphere.png", width = 5000, height = 4000)
# A <- plot_word3D(word = "copula", R = 100, orbit = 300, copula = FALSE, plot.rgl = FALSE,
#                  plot.surface = "Sphere", cex.label = 5, size.lines = 2)
# dev.off()
}
