% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfC_vonMises.R
\name{cfC_vonMises}
\alias{cfC_vonMises}
\title{Characteristic function of von Mises distribution}
\usage{
cfC_vonMises(t, mu = 0, kappa = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{mu}{in (-pi, pi)}

\item{kappa}{> 0}
}
\value{
characteristic function cf(t) of the von Mises distribution with the parameters mu and kappa > 0
}
\description{
cfC_vonMises(t) evaluates the characteristic function cf(t) of
the von Mises distribution (circular normal distribution) with the
parameters mu in (-pi,pi) and kappa > 0 (mu and 1/kappa are analogous to
mu and sigma^2, the mean and variance in the normal distribution), on a
circle e.g. the interval (-pi,pi), i.e.
cf(t) = besseli(t,kappa)/besseli(0,kappa) .* exp(1i*t*mu).
}
\examples{
# EXAMPLE1 (CF of the uniform von Mises distribution on (-pi,pi))
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfC_vonMises(t), t, title = "CF of the uniform von Mises distribution on (-pi,pi)")

# EXAMPLE2 (CF of the mixture of the von Mises distribution on (-pi,pi))
mu1 <- 0
kappa1 <- 5
mu2 <- 1
kappa2 <- 15
cf <-
  function(t)
    0.25 * cfC_vonMises(t, mu1, kappa1) + 0.75 * cfC_vonMises(t, mu2, kappa2)
t <- seq(-10, 10, length.out = 501)
plotGraf(cf, t, title = "CF of the mixture of the von Mises distribution")

# EXAMPLE3 (PDF/CDF of the von Mises distribution on (-pi,pi))
mu <- 0
kappa <- 5
cf  <- function(t)
  cfC_vonMises(t, mu, kappa)
result <- cf2DistGP(cf, xMin = -pi, xMax = pi)
angle <- result$x
radius <- result$pdf
plotPolar(angle, radius)

# EXAMPLE4 (PDF/CDF of the linear combinantion of 2 von Mises distribution on (-pi,pi))
mu1 <- 0
kappa1 <- 5
mu2 <- 1
kappa2 <- 15
cf <-
  function(t)
    cfC_vonMises(1 * t, mu1, kappa1) * cfC_vonMises(0.25 * t, mu2, kappa2)
result <- cf2DistGP(cf,
                    xMin = -pi,
                    xMax = pi,
                    isCircular = TRUE)
angle <- result$x
radius <- result$pdf
plotPolar(angle, radius)

# EXAMPLE5 (PDF/CDF of the mixture of the von Mises distribution on (0,2*pi))
mu1 <- 0
kappa1 <- 5
mu2 <- 1
kappa2 <- 15
mu3 <- pi
kappa3 <- 10
cf <-
  function(t)
    0.25 * cfC_vonMises(t, mu1, kappa1) + 0.25 * cfC_vonMises(t, mu2, kappa2) + 0.5 *
  cfC_vonMises(t, mu3, kappa3)
result <- cf2DistGP(cf,
                    xMin =  0,
                    xMax = 2 * pi,
                    isCircular = TRUE)
angle <- result$x
radius <- result$pdf
plotPolar(angle, radius)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Von_Mises_distribution}
}

