% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfS_Rectangular.R
\name{cfS_Rectangular}
\alias{cfS_Rectangular}
\title{Characteristic function of Rectangular distribution}
\usage{
cfS_Rectangular(t, a = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{number, a > 0, default value a = 1}
}
\value{
characteristic function cf(t) of the Rectangular distribution on the interval (-a, a)
}
\description{
cfS_Rectangular(t) evaluates the characteristic function cf(t) of
the symmetric zero-mean Rectangular distribution on the interval (-a, a)
(Rectangular distribution with mean = 0 and variance = 1/3*a^2)
cfS_Rectangular(t, a) = sin(at)/at
}
\examples{
## EXAMPLE1 (CF of the Rectangular distribution on (-1,1))
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfS_Rectangular(t), t, title = "CF of the Rectangular distribution on (-1,1)")

## EXAMPLE2 (PDF/CDF of the Rectangular distribution on (-1,1))
cf <- function(t)
  cfS_Rectangular(t)
x <- seq(-2, 2, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
xRange <- 2
option <- list()
option$N <- 2 ^ 10
option$dx <- 2 / pi / xRange
result <- cf2DistGP(cf, x, prob, option)

## EXAMPLE3 (PDF/CDF of the Rectangular distribution on (-1,1))
cf <- function(t)
  cfS_Rectangular(t)
x <- seq(-1, 1, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf,
                    x,
                    prob,
                    xMin = -1,
                    xMax = 1,
                    N = 2)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Uniform_distribution_(continuous)}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}

Other Symetric Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Gaussian}}, \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}
}

