% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfX_Triangular.R
\name{cfX_Triangular}
\alias{cfX_Triangular}
\title{Characteristic function of Triangular distribution}
\usage{
cfX_Triangular(t, a = -1, b = 1, c = 0)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{number, default value a = -1}

\item{b}{number, default value b = 1}

\item{c}{number, (\eqn{a \le c \le b}), default value c = 0}
}
\value{
characteristic function cf(t) of the Triangular distribution on the interval (a, b) with mode c
}
\description{
cfX_Triangular(t, a, b, c) (\eqn{a \le c \le b}) evaluates the characteristic function cf(t) of
the Triangular distribution on the interval (a, b) with mode c
(Triangular distribution with mean = a + b + c)/3 and variance = 1/18(a^2 + b^2 + c^2 + - ab - ac - bc))
cfX_Triangula(t, a, b, c) = -2((b-c)exp(iat) - (b-a)exp(ict) + (c-a)exp(ibt))/((b-a)(c-a)(b-c)t^2)
}
\examples{
## EXAMPLE1 (CF of the Triangular distribution on (-1 , 2) mode = 0)
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfX_Triangular(t, a = -1, b = 2, c = 0), t,
  title = "CF of the Triangular distribution on (-1 , 2)")

## EXAMPLE2 (PDF/CDF of the Triangular distribution on (-1 , 2) mode = 0)
cf <- function(t)
  cfX_Triangular(t, a = -1, b = 2, c = 0)
x <- seq(-1, 2, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
xRange <- 3
option <- list()
option$N <- 2 ^ 10
option$dx <- 2 / pi / xRange
result <- cf2DistGP(cf, x, option = option)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Triangular_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}}, \code{\link{cfX_Rectangular}}
}

