% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files2SpectraObject.R, R/matrix2SpectraObject.R
\name{files2SpectraObject}
\alias{files2SpectraObject}
\alias{matrix2SpectraObject}
\title{Import Data into a Spectra Object}
\usage{
files2SpectraObject(gr.crit = NULL, gr.cols = c("auto"),
  freq.unit = "no frequency unit provided",
  int.unit = "no intensity unit provided",
  descrip = "no description provided", fileExt = "\\\\.(csv|CSV)$",
  out.file = "mydata", debug = FALSE, ...)

matrix2SpectraObject(gr.crit = NULL, gr.cols = c("auto"),
  freq.unit = "no frequency unit provided",
  int.unit = "no intensity unit provided",
  descrip = "no description provided", in.file = NULL,
  out.file = "mydata", chk = TRUE, ...)
}
\arguments{
\item{gr.crit}{Group Criteria.  A vector of character strings which will be
searched for among the file names in order to assign an individual
spectrum/sample to group membership. Warnings are issued if there are file
names that don't match entries in \code{gr.crit} or there are entries in
\code{gr.crit} that don't match any file names. See Details for some
nuances.}

\item{gr.cols}{Group Colors.  Either the word "auto", in which case colors
will be automatically assigned, or a vector of acceptable color names with
the same length as \code{gr.crit}. In the latter case, colors will be
assigned one for one, so the first element of \code{gr.crit} is assigned the
first element of \code{gr.col} and so forth.  See details below for some
other issues to consider.}

\item{freq.unit}{A character string giving the units of the x-axis
(frequency or wavelength).}

\item{int.unit}{A character string giving the units of the y-axis (some sort
of intensity).}

\item{descrip}{A character string describing the data set that will be
stored.  This string is used in some plots so it is recommended that its
length be less than about 40 characters.}

\item{fileExt}{A character string giving the extension of the files to be
processed. \code{regex} strings can be used.  For instance, the default
finds files with either \code{".csv"} or \code{".CSV"} as the extension.
Matching is done via a grep process, which is greedy.}

\item{out.file}{A file name.  The
completed object of S3 class \code{\link{Spectra}} will be written to this
file.}

\item{debug}{Logical. Applies to \code{files2SpectraObject} only.
Set to \code{TRUE} for troubleshooting when an error
is thrown during import.  In addition, values of 1-5 will work
when importing a JCAMP-DX file via \code{fileExt = ".jdx"} etc.  These
will be passed through to the \code{\link[readJDX]{readJDX}} function.
See there for much more info on importing JCAMP-DX files.}

\item{...}{Arguments to be passed to \code{\link[utils]{read.table}}.  \pkg{You
MUST supply values for \code{sep}, \code{dec} and \code{header} consistent
with your file structure, unless they are the same as the defaults for
\code{\link[utils]{read.table}}}.}

\item{in.file}{Character.  Applies to \code{matrix2SpectraObject} only.
Input file name, including extension.}

\item{chk}{Logical. Applies to \code{matrix2SpectraObject} only.
Should the \code{Spectra} object be checked for
integrity?  If you are having trouble importing your data, set this to
\code{FALSE} and do \code{str(your object)} to troubleshoot.}
}
\value{
A object of class \code{\link{Spectra}}.  An \emph{unnamed} object
of S3 class \code{\link{Spectra}} is also written to \code{out.file}.  To
read it back into the workspace, use \code{new.name <- loadObject(out.file)}
(\code{loadObject} is package \pkg{R.utils}).
}
\description{
These functions import data into a \code{\link{Spectra}} object.  They use
\code{\link[utils]{read.table}} to read files so they are
very flexible in regard to file formatting.  \pkg{Be sure to see the \ldots
argument below for important details you need to provide.}
}
\details{
The matching of \code{gr.crit} against the sample file names is done one at
a time, in order.  This means that the entries in \code{gr.crit} must be
mutually exclusive.  For example, if you have files with names like
"Control_1" and "Sample_1" and use \code{gr.crit = c("Control", "Sample")}
groups will be assigned as you would expect.  But, if you have file names
like "Control_1_Shade" and "Sample_1_Sun" you can't use \code{gr.crit =
c("Control", "Sample", "Sun", "Shade")} because each criteria is grepped in
order, and the "Sun/Shade" phrases, being last, will form the basis for your
groups.  Because this is a grep process, you can get around this by using
regular expressions in your \code{gr.crit} argument to specify the desired
groups in a mutually exclusive manner.  In this second example, you could
use \code{gr.crit = c("Control(.*)Sun", "Control(.*)Shade", "Sample(.*)Sun",
"Sample(.*)Shade")} to have your groups assigned based upon both phrases in
the file names.

The linking of groups with colors is handled by \code{\link{groupNcolor}}.

Samples whose names are not matched using \code{gr.crit} are still
incorporated into the \code{\link{Spectra}} object, but they are not
assigned a group or color. Therefore they don't plot, but they do take up space in a
plot!  A warning is issued in these cases, since one wouldn't normally want
a spectrum to be orphaned this way.

If \code{fileExt} contains any of \code{"dx"}, \code{"DX"}, \code{"jdx"} or
\code{"JDX"}, then the files will be processed by \code{\link[readJDX]{readJDX}}.
Consider setting \code{debug = TRUE} for this format, as there are many
options for JCAMP, and many are untested. See \code{\link[readJDX]{readJDX}} for
known limitations.
}
\section{Functions}{
\itemize{
\item \code{files2SpectraObject}: Import data from separate csv files

\item \code{matrix2SpectraObject}: Import a matrix of data
}}
\section{files2SpectraObject}{

\code{files2SpectraObject} acts on all files in the current working
directory with the specified \code{fileExt}.  The first column should
contain the frequency values and the second column the intensity values. The
files may have a header or not (supply \code{header = TRUE/FALSE} as
necessary).  The frequency column is assumed to be the same in all files.
}

\section{matrix2SpectraObject}{

This function takes a csv-like file, containing frequencies in the first
column, and samples in additional columns, and processes it into a
\code{\link{Spectra}} object.  The file MUST have a header row which includes
the sample names.  There need not be a header for the first (frequency)
column.
}
\examples{
td <- tempdir()
ed <- system.file("extdata", package = "ChemoSpec")
tf <- "PCRF.jdx"
chk <- file.copy(from = file.path(ed, tf), to = file.path(td, tf),
	overwrite = TRUE)
setwd(td)
spec <- files2SpectraObject(gr.crit = "PCRF", freq.unit = "ppm", int.unit = "intensity",
	descrip = "test import", fileExt = ".jdx")
sumSpectra(spec)
plotSpectra(spec, lab.pos = 3.5, main = "Reduced Fat Potato Chip")

}
\author{
Bryan A. Hanson, DePauw University.
}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\keyword{file}
\keyword{import}

