% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seXy.R
\name{seX}
\alias{seX}
\alias{seXy}
\alias{seXy95}
\alias{seXyIqr}
\alias{seXyMad}
\title{Functions to Compute Measures of Central Tendency and Spread.  seX!}
\usage{
seX(x)

seXy(x)

seXy95(x)

seXyIqr(x)

seXyMad(x)
}
\arguments{
\item{x}{A vector of numeric values whose measure of central tendency and
spread are to be computed.}
}
\value{
For all but \code{seX}, a vector of 3 numeric values, giving the
measure of central tendency, that measure + the spread, and that measure -
the spread.
For \code{seX}, a single value giving the standard error of x.
}
\description{
These functions compute various measures of central tendency and spread.
These functions return a vector containing the measure of central tendency,
as well as that measure +/- the requested spread.  \code{seX} is a little
different from the others in that it simply returns the standard error of x,
hence \code{seX}.  Haven't we always needed a function for \code{seX}?
}
\details{
These functions include \code{na.omit}.
}
\section{Functions}{
\itemize{
\item \code{seX}: standard error of x

\item \code{seXy}: mean +/- the standard error

\item \code{seXy95}: mean +/- the standard error at 95\% conf. interval

\item \code{seXyIqr}: median +/- the 1st and 3rd quantile

\item \code{seXyMad}: median +/- median absolute deviation
}}
\examples{

x <- rnorm(100)
seX(x)
seXy(x)
seXy95(x)
seXyMad(x)
seXyIqr(x)

}
\author{
Bryan A. Hanson, DePauw University.
}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\keyword{utilities}

