% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toChemoSpec.R
\name{toChemoSpec}
\alias{toChemoSpec}
\title{Convert a \code{Spectra2D} Object to a \code{Spectra} Object by Linearizing}
\usage{
toChemoSpec(spectra)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}
}
\value{
A object of S3 class \code{\link[ChemoSpec]{Spectra}}.
}
\description{
A utility function which takes a \code{Spectra2D} object and linearizes it.
Each 2D spectrum corresponding to a sample is linearized by taking each F1 slice
and assembling them one after the other into a vector.  The
frequency axis is replaced with an index (though it is stored as a real vector
to satisfy the definition of a \code{\link[ChemoSpec]{Spectra}} object).
The frequency vector will be equal to the length of the F2 dimension times
the length of the F1 dimension.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{utilities}
