% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPrecipitation.R
\name{getPrecipitation}
\alias{getPrecipitation}
\title{Assemble a precipitation times series}
\usage{
getPrecipitation(start, end, geometry, att, val = NA)
}
\arguments{
\item{start}{start date in format 'YYYY-MM-DD'}

\item{end}{end date in format 'YYYY-MM-DD'}

\item{geometry}{name of geometry as displayed in GDP}

\item{att}{attribute of geometry as displayed in GDP}

\item{val}{values of attribute as displayed in GDP}
}
\value{
monthly precipitation, averaged spatially over geometry
}
\description{
This function retrieves monthly precipitation, minimum and maximum 
temperatures for a given area from PRISM model output hosted by the USGS 
Geo Data Portal (GDP)
}
\examples{
\dontrun{
prcp <- getPrecipitation('2010-01-01', '2010-12-31', 'sample:Counties', 'STATE',
'RI')
}
}
