% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{fffi}
\alias{fffi}
\title{Finnish Forest Fire Index}
\usage{
fffi(data, evap, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{precipitation}

\item{evap}{potential evapotranspiration}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
FFFI
}
\description{
Finnish forest fire index is determined from the surface moisture, by estimating the volumetric moisture of a 60 mm thick soil surface layer using potential evaporation and precipitation data.
}
\examples{
data(data_all)
fffi(data = data_all$rr, evap=data_all$evapotranspiration)
}
\references{
Venäläinen A, Heikinheimo M. 2003. The Finnish forest fire index calculation system. In Early Warning Systems for Natural Disaster Reduction, Zschau J, Kuppers A (eds). Springer: Berlin; 645–648.. Vajda, A., Venalainen, A., Suomi, I., Junila, P. and Makela, H., 2014. Assessment of forest fire danger in a boreal forest environment: description and evaluation of the operational system applied in Finland. Meteorol. Appl., 21: 879-887, DOI: 10.1002/met.1425
}
