% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{spei6}
\alias{spei6}
\title{Standardised Precipitation-Evapotranspiration Index 6}
\usage{
spei6(eto, pr, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{eto}{et0}

\item{pr}{precipitation}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{...}
}
\value{
SPEI
}
\description{
Standardized precipitation-evapotranspiration index calculated at 6-month time scale
}
\examples{
data(data_all)
spei6(eto = data_all$evapotranspiration, pr = data_all$rr)
}
\references{
Vicente-Serrano, S. M., Beguería, S. and López-Moreno, J. I.: A multiscalar drought index sensitive to global warming: The standardized precipitation evapotranspiration index, J. Clim., 23(7), doi:10.1175/2009JCLI2909.1, 2010.
}
