% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{case.study.psychiatrist}
\alias{case.study.psychiatrist}
\title{Patient by psychiatric symptom data}
\format{
\subsection{\code{case.study.psychiatrist}}{

A data frame with 30 observations on the following 28 variables:
\describe{
\item{\code{V1}}{inappropriate affect, appearance or behavior; binary vector}
\item{\code{V2}}{interview belligerence - negativism; binary vector}
\item{\code{V3}}{agitation - excitement; binary vector}
\item{\code{V4}}{retardation; binary vector}
\item{\code{V5}}{lack of emotions; binary vector}
\item{\code{V6}}{speech disorganization; binary vector}
\item{\code{V7}}{grandiosity; binary vector}
\item{\code{V8}}{suspicion - ideas of persecution; binary vector}
\item{\code{V9}}{hallucinations - delusions; binary vector}
\item{\code{V10}}{overt anger; binary vector}
\item{\code{V11}}{depression; binary vector}
\item{\code{V12}}{anxiety; binary vector}
\item{\code{V13}}{obsession - compulsion; binary vector}
\item{\code{V14}}{suicide; binary vector}
\item{\code{V15}}{self injury; binary vector}
\item{\code{V16}}{somatic concerns; binary vector}
\item{\code{V17}}{social isolation; binary vector}
\item{\code{V18}}{daily routine impairment; binary vector}
\item{\code{V19}}{leisure time impairment; binary vector}
\item{\code{V20}}{antisocial impulses or acts; binary vector}
\item{\code{V21}}{alcohol abuse; binary vector}
\item{\code{V22}}{drug abuse; binary vector}
\item{\code{V23}}{disorientation; binary vector}
\item{\code{V24}}{memory impairment; binary vector}
\item{\code{V25}}{rating on Global Assessment Scale, a 101-point scale for overall severity of psychiatric disturbance; a numeric vector}
\item{\code{V26}}{Affective (Affective Disorder or Anxiety Disorder); binary vector}
\item{\code{V27}}{Psychotic (Schizophrenic Disorder or Paranoid Disorder); binary vector}
\item{\code{V28}}{Substance abuse (Substance Use Disorder or Substance-Induced Disorder); binary vector}
}
}
}
\source{
Van Mechelen, I., & De Boeck, P. (1989). Implicit taxonomy in psychiatric diagnosis: A case study. Journal of Social and Clinical Psychology, 8, 276-287.
\url{https://ifcs.boku.ac.at/repository/data/case_study_psychiatrist/index.html}
}
\usage{
case.study.psychiatrist
}
\description{
Presence/absence ratings of 24 psychiatric symptoms in 30 psychiatric inpatients made by an individual psychiatrist.
The data have been collected in a case study of an individual psychiatrist to identify his implicit taxonomy.
}
\details{
{
The data set forms part of the International Federation of Classification Societies Cluster Benchmark Data Repository
}
}
\keyword{datasets}
