% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp.torus.kde.R
\name{cp.torus.kde}
\alias{cp.torus.kde}
\title{Conformal prediction set indices with kernel density estimation}
\usage{
cp.torus.kde(data, eval.point = grid.torus(), level = 0.1, concentration = 25)
}
\arguments{
\item{data}{n x 2 matrix of toroidal data on \eqn{[0, 2\pi)^2}}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^2}. Default input is
\code{grid.torus}.}

\item{level}{either a scalar or a vector, or even \code{NULL}. Default value
is 0.1.}

\item{concentration}{positive number which has the role of \eqn{\kappa} of
von Mises distribution. Default value is 25.}
}
\value{
If \code{level} is \code{NULL}, then return kde at \code{eval.point}
  and at data points.

  If \code{level} is a vector, return the above and prediction set indices
  for each value of level.
}
\description{
\code{cp.torus.kde} computes conformal prediction set indices
  (TRUE if in the set) using kernel density estimation as conformity score.
}
\examples{
data <- ILE[1:200, 1:2]
cp.torus.kde(data, eval.point = grid.torus(),
             level = 0.05, concentration = 25)
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
\seealso{
\code{\link{kde.torus}}, \code{\link{grid.torus}}
}
