% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusvismixmod.R
\name{clusvisMixmod}
\alias{clusvisMixmod}
\title{This function estimates the parameters used for visualization of model-based clustering performs with R package Rmixmod. To achieve the parameter infernece, it automatically samples probabilities of classification from the model parameters}
\usage{
clusvisMixmod(mixmodResult, sample.size = 5000, maxit = 10^3,
  nbrandomInit = 4 * mixmodResult@bestResult@nbCluster, nbcpu = 1,
  loccont = NULL)
}
\arguments{
\item{mixmodResult}{[\code{\linkS4class{MixmodCluster}}] It is an instance of class MixmodCluster returned by function mixmodCluster of R package Rmixmod.}

\item{sample.size}{numeric. Number of probabilities of classification sampled for parameter inference.}

\item{maxit}{numeric. It limits the number of iterations for the Quasi-Newton algorithm (default 1000).}

\item{nbrandomInit}{numeric. It defines the number of random initialization of the Quasi-Newton algorithm.}

\item{nbcpu}{numeric. It specifies the number of CPU (only for linux).}

\item{loccont}{numeric. Index of the column containing continuous variables (only for mixed-type data).}
}
\value{
Returns a list
}
\description{
This function estimates the parameters used for visualization of model-based clustering performs with R package Rmixmod. To achieve the parameter infernece, it automatically samples probabilities of classification from the model parameters
}
\examples{
\dontrun{

 ## First example: R package Rmixmod
 # Package loading
 require(Rmixmod)

 # Data loading (categorical data)
 data("congress")
 # Model-based clustering with 4 components
 set.seed(123)
 res <- mixmodCluster(congress[,-1], 4, strategy = mixmodStrategy(nbTryInInit = 500, nbTry=25))

 # Inference of the parameters used for results visualization
 # (specific for Rmixmod results)
 # It is better because probabilities of classification are generated
 # by using the model parameters
 resvisu <- clusvisMixmod(res)

 # Component interpretation graph
 plotDensityClusVisu(resvisu)

 # Scatter-plot of the observation memberships
 plotDensityClusVisu(resvisu,  add.obs = TRUE)


## Second example: R package Rmixmod
# Package loading
require(Rmixmod)
 
# Data loading (categorical data)
data(birds)

# Model-based clustering with 3 components
resmixmod <- mixmodCluster(birds, 3)

# Inference of the parameters used for results visualization (general approach)
# Probabilities of classification are not sampled from the model parameter,
# but observed probabilities of classification are used for parameter estimation
resvisu <- clusvis(log(resmixmod@bestResult@proba),
                   resmixmod@bestResult@parameters@proportions)

# Inference of the parameters used for results visualization
# (specific for Rmixmod results)
# It is better because probabilities of classification are generated
# by using the model parameters
resvisu <- clusvisMixmod(resmixmod)

# Component interpretation graph
plotDensityClusVisu(resvisu)

# Scatter-plot of the observation memberships
plotDensityClusVisu(resvisu,  add.obs = TRUE)
}
}
