% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePower.R
\name{computePower}
\alias{computePower}
\title{Power Calculations for Assessing Intermediate Biomarkers as Correlates of Risk in the Active Treatment Group in Clinical Efficacy Trials, Accounting for Biomarker's Measurement Error and Treatment Efficacy}
\usage{
computePower(nCases, nControls, nCasesWithS, controlCaseRatio = NULL,
  VEoverall, risk0, VElat0 = seq(0, VEoverall, len = 20),
  VElat1 = rep(VEoverall, 20), VElowest = NULL, Plat0 = 0.2,
  Plat2 = 0.6, P0 = Plat0, P2 = Plat2, PlatVElowest = NULL,
  spec = NULL, FP0 = NULL, sens = NULL, FN2 = NULL, M = 100,
  alpha = 0.05, sigma2obs = 1, rho = 1, biomType = c("continuous",
  "trichotomous", "dichotomous"), cohort = FALSE, p = NULL,
  tpsMethod = c("PL", "ML", "WL"), saveDir = NULL, saveFile = NULL)
}
\arguments{
\item{nCases}{an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group (a numeric vector of multiple counts/scenarios is allowed)}

\item{nControls}{an integer value specifying the number of controls observed (or projected) to complete follow-up through \eqn{\tau_{max}} endpoint-free in the active treatment group (a numeric vector of multiple counts/scenarios is allowed)}

\item{nCasesWithS}{an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response (a numeric vector of multiple counts/scenarios is allowed)}

\item{controlCaseRatio}{an integer value specifying the number of controls sampled per case for biomarker measurement in the without replacement case-control sampling design}

\item{VEoverall}{a numeric value specifying the overall treatment (vaccine) efficacy between \eqn{\tau} and \eqn{\tau_{max}}}

\item{risk0}{a numeric value specifying the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}}

\item{VElat0}{a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lower protected subgroup for a dichotomous or trichotomous biomarker. Each value of \code{VElat0} corresponds to one unique effect size (\eqn{RR_t}). It typically ranges from \code{VEoverall} (\eqn{H_0}) to 0 (maximal \eqn{H_1} not allowing harm by treatment).}

\item{VElat1}{a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent medium protected subgroup for a trichotomous biomarker (\code{NULL} by default for a dichotomous biomarker)}

\item{VElowest}{a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup for a continuous biomarker. It typically ranges from \code{VEoverall} (\eqn{H_0}) to 0 (maximal \eqn{H_1} not allowing harm by treatment).}

\item{Plat0}{a numeric value specifying the prevalence of the latent lower protected subgroup for a dichotomous or trichotomous biomarker}

\item{Plat2}{a numeric value specifying the prevalence of the latent higher protected subgroup for a dichotomous or trichotomous biomarker}

\item{P0}{a numeric value specifying the probability of low biomarker response for a dichotomous or trichotomous biomarker. If unspecified, it is set to \code{Plat0}.}

\item{P2}{a numeric value specifying the probability of high biomarker response for a dichotomous or trichotomous biomarker. If unspecified, it is set to \code{Plat2}.}

\item{PlatVElowest}{a numeric value specifying the prevalence of the latent lowest-efficacy subgroup for a continuous biomarker}

\item{spec}{a numeric vector specifying the specificity, i.e., the probability of low biomarker response conditional on membership in the lower protected subgroup, of a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'.}

\item{FP0}{a numeric vector specifying the false positive rate, i.e., the probability of high biomarker response conditional on membership in the lower protected subgroup, for a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'.}

\item{sens}{a numeric vector specifying the sensitivity, i.e., the probability of high biomarker response conditional on membership in the higher protected subgroup, for a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'.}

\item{FN2}{a numeric vector specifying the false negative rate, i.e., the probability of low biomarker response conditional on membership in the higher protected subgroup, for a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'.}

\item{M}{an integer value specifying the number of simulated clinical trials}

\item{alpha}{a numeric value specifying the two-sided Wald test type-I error rate}

\item{sigma2obs}{a numeric value specifying the variance of the observed continuous biomarker or of the dichotomous or trichotomous biomarker simulated using 'approach 2'}

\item{rho}{a numeric vector specifying distinct protection-relevant fractions of \code{sigma2obs}}

\item{biomType}{a character string specifying the biomarker type. Default is \code{continuous}; other choices are \code{dichotomous} and \code{trichotomous}.}

\item{cohort}{a logical value for whether a case-cohort Bernoulli sampling design is to be used. If \code{FALSE} (default), the case-control without replacement sampling is used.}

\item{p}{a numeric value specifying the probability of sampling into the subcohort in the case-cohort design}

\item{tpsMethod}{a character string specifying the estimation method in the inverse probability weighted logistic regression model fit by the \code{tps} function in the \code{osDesign} package. The options are \code{PL} for pseudo-likelihood (default), \code{ML} for maximum likelihood, and \code{WL} for weighted likelihood.}

\item{saveDir}{a character string specifying the path for a directory in which the output is to be saved. If \code{NULL} (default), the output is returned only.}

\item{saveFile}{a character string specifying the name of the \code{.RData} file storing the output. If \code{NULL} (default), the output is returned only.}
}
\value{
If \code{saveFile} and \code{saveDir} are both specified, the output list (named \code{pwr}) is saved as an \code{.RData} file; otherwise it is returned only.
For a dichotomous or trichotomous biomarker, the output list has the following components:
\itemize{
  \item \code{power}: a matrix of fractions of simulated trials in which the null hypothesis \eqn{H_0} is rejected. Rows represent calculations for different values of \code{rho}, \code{sens}, or \code{nCases}, depending on which is a vector. Columns represent calculations for the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{RRt}: a matrix of correlate-of-risk relative-risk effect sizes. Rows represent different values of \code{rho}, \code{sens}, or \code{nCases}, depending on which is a vector. Columns represent the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{risk1_2}: a matrix of conditional endpoint risks given a high biomarker response in the active treatment group. Rows represent different values of \code{rho}, \code{sens}, or \code{nCases}, depending on which is a vector. Columns represent the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{risk1_0}: a matrix of conditional endpoint risks given a low biomarker response in the active treatment group. Rows represent different values of \code{rho}, \code{sens}, or \code{nCases}, depending on which is a vector. Columns represent the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{VElat2}: a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent higher protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{VElat0}: a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lower protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{Plat2}: a numeric value specifying the prevalence of the latent higher protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{Plat0}: a numeric value specifying the prevalence of the latent lower protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{P2}: a numeric value specifying the probability of high biomarker response for a dichotomous or trichotomous biomarker
  \item \code{P0}: a numeric value specifying the probability of low biomarker response for a dichotomous or trichotomous biomarker
  \item \code{alphaLat}: a numeric vector of the log odds of the clinical endpoint in the subgroup of active treatment recipients with the latent \eqn{x^{\ast}=0} (this coefficient estimate applies to a continuous biomarker)
  \item \code{betaLat}: a numeric vector of the log odds ratio of the clinical endpoint comparing two subgroups of active treatment recipients differing in the latent \eqn{x^{\ast}} by 1 (this coefficient estimate applies to a continuous biomarker)
  \item \code{sens}: a numeric vector of sensitivities (i.e., the probability of high biomarker response conditional on membership in the higher protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{spec}: a numeric vector of specificities (i.e., the probability of low biomarker response conditional on membership in the lower protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{FP0}: a numeric vector of false positive rates (i.e., the probability of high biomarker response conditional on membership in the lower protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{FN2}: a numeric vector of false negative rates (i.e., the probability of low biomarker response conditional on membership in the higher protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{Ncomplete}: an integer value specifying \code{nCases} + \code{nControls}, i.e., the number, observed or projected, of active treatment recipients at risk at \eqn{\tau} with an observed endpoint or a completed follow-up through \eqn{\tau_{max}}
  \item \code{nCases}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group
  \item \code{nCasesWithS}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response
  \item \code{controlCaseRatio}: an integer specifying the number of controls sampled per case for
  biomarker measurement in the without replacement case-control sampling design
  \item \code{VEoverall}: a numeric value specifying the overall treatment (vaccine) efficacy between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{risk0}: a numeric value specifying the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{alpha}: a numeric value specifying the two-sided Wald test type-I error rate
  \item \code{rho}: a numeric vector specifying distinct protection-relevant fractions of the variance of the observed biomarker
}

For a continuous biomarker, a list with the following components:
\itemize{
  \item \code{power}: a matrix of fractions of simulated trials in which the null hypothesis \eqn{H_0} is rejected. Rows represent calculations for different values of \code{rho} or \code{nCases}, depending on which is a vector. Columns represent calculations for the grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup, specified by \code{VElowest}.
  \item \code{RRc}: a numeric vector of correlate-or-risk relative-risk effect sizes as a function of the grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup, specified by \code{VElowest}
  \item \code{betaLat}: a numeric vector specifying the log odds ratio of the clinical endpoint comparing two subgroups of active treatment recipients differing in the latent \eqn{x^{\ast}} by 1 (this coefficient estimate applies to a continuous biomarker)
  \item \code{alphaLat}: a numeric vector specifying the the log odds of the clinical endpoint in the subgroup of active treatment recipients with the latent \eqn{x^{\ast}=0} (this coefficient estimate applies to a continuous biomarker)
  \item \code{PlatVElowest}: a numeric value specifying the prevalence of the latent lowest-efficacy subgroup for a continuous biomarker
  \item \code{VElowest}: a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup for a continuous biomarker
  \item \code{sigma2obs}: a numeric value specifying the variance of the observed continuous biomarker or of the dichotomous or trichotomous biomarker simulated using 'approach 2'
  \item \code{Ncomplete}: an integer value specifying \code{nCases} + \code{nControls}, i.e., the number, observed or projected, of active treatment recipients at risk at \eqn{\tau} with an observed endpoint or a completed follow-up through \eqn{\tau_{max}}
  \item \code{nCases}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group
  \item \code{nCasesWithS}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response
  \item \code{VEoverall}: a numeric value specifying the overall treatment (vaccine) efficacy between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{alpha}: a numeric value specifying the two-sided Wald test type-I error rate
  \item \code{rho}: a numeric vector specifying distinct protection-relevant fractions of the variance of the observed biomarker
  \item \code{controlCaseRatio}: an integer value specifying the number of controls sampled per case for biomarker measurement in the without replacement case-control sampling design
  \item \code{risk0}: a numeric value specifying the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}
}
}
\description{
Performs a power calculation for assessing a univariate dichotomous, trichotomous, or continuous intermediate biomarker response as a correlate of risk
in the active treatment group in a clinical efficacy trial, accounting for the biomarker's measurement error and treatment efficacy. The statistical methods are described in [Gilbert, Janes, and Huang (2016).
``Power/Sample Size Calculations for Assessing Correlates of Risk in Clinical Efficacy Trials.'']
}
\details{
If \code{nCases}, \code{nControls}, and \code{nCasesWithS} are vectors (of the same length), then \code{rho} must be a scalar.

To save output in an \code{.RData} file, both \code{saveDir} and \code{saveFile} must be specified.

Parameters independent of biomarker type and sampling design: \code{nCases}, \code{nControls}, \code{nCasesWithS}, \code{VEoverall}, \code{risk0},
\code{M}, \code{alpha}, \code{tpsMethod}, \code{saveDir}, \code{saveFile}.

Parameters for trichotomous (or dichotomous) biomarker: \code{VElat0}, \code{VElat1}, \code{Plat0}, \code{Plat2}, \code{P0},
\code{P2}, \code{biomType = "trichotomous"} (or \code{"dichotomous"})
  \itemize{
    \item Parameters for Approach 1: \code{sens}, \code{spec}, \code{FP0}, \code{FN2}
    \item Parameters for Approach 2: \code{sigma2obs}, \code{rho}
  }

Parameters for continuous biomarker: \code{VElowest}, \code{PlatVElowest}, \code{sigma2obs}, \code{rho}, \cr\code{biomType = "continuous"}

Parameters for a case-control without replacement sampling design: \code{controlCaseRatio}

Parameters for a case-cohort Bernoulli sampling design: \code{cohort = TRUE}, \code{p}
}
\examples{

## Trichotomous biomarker, Approach 1, varying sens and spec ##
## Specify sens, spec, FP0, FN2
nCases <- 32
nControls <- 1000
nCasesWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=20)  # 20 data points for the power curve
VElat1 <- rep(VEoverall, 20)
Plat0 <- 0.2
Plat2 <- 0.6
P0 <- Plat0  # different values of P0 can be set
P2 <- Plat2  # different values of P2 can be set
sens <- spec <- c(1, 0.9, 0.8, 0.7)
FP0 <- FN2 <- rep(0, 4)
M <- 5
alpha <- 0.05
biomType <- "trichotomous"
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall,
             risk0=risk0, VElat0=VElat0, VElat1=VElat1, Plat0=Plat0,
             Plat2=Plat2, P0=P0, P2=P2, M=M, alpha=alpha, spec=spec,
             FP0=FP0, sens=sens, FN2=FN2, biomType=biomType)

\dontrun{
## Trichotomous biomarker, Approach 2, varying rho ##
## Specify rho and sigma2obs

nCases <- 32
nControls <- 1000
nCasesWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=20)
VElat1 <- rep(VEoverall, 20)
Plat0 <- 0.2
Plat2 <- 0.6
P0 <- Plat0
P2 <- Plat2
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "trichotomous"
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall, risk0=risk0,
             VElat0=VElat0, VElat1=VElat1, Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2,
             M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho, biomType=biomType)


## dichotomous biomarker, Approach 2, varying rho ##
## Plat0 + Plat2 = 1

nCases <- 32
nControls <- 1000
nCasesWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=20)  # 20 data points for the power curve
VElat1 <- rep(0, 20)  # will not be used by function
Plat0 <- 0.2
Plat2 <- 1 - Plat0
P0 <- Plat0
P2 <- Plat2
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "dichotomous"
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall, risk0=risk0,
             VElat0=VElat0, VElat1=VElat1, Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2,
             M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho, biomType=biomType)


## Continuous biomarker, varying rho ##

nCases <- 32
nControls <- 1000
nCasesWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=20)
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "continuous"
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall, risk0=risk0,
             PlatVElowest=PlatVElowest, VElowest=VElowest, M=M, alpha=alpha,
             sigma2obs=sigma2obs, rho=rho, biomType=biomType)


## Continuous biomarker, case-cohort sampling design, varying p ##
nCases <- 32
nControls <- 1000
nCasesWithS <- 32
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=20)
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- 0.9
biomType <- "continuous"
cohort <- TRUE
p <- 0.01
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             VEoverall=VEoverall, risk0=risk0, PlatVElowest=PlatVElowest,
             VElowest=VElowest, M=M, alpha=alpha, sigma2obs=sigma2obs,
             rho=rho, biomType=biomType, cohort=cohort, p=p)
p <- 0.02
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             VEoverall=VEoverall, risk0=risk0, PlatVElowest=PlatVElowest,
             VElowest=VElowest, M=M, alpha=alpha, sigma2obs=sigma2obs,
             rho=rho, biomType=biomType, cohort=cohort, p=p)
p <- 0.03
computePower(nCases=nCases, nControls=nControls, nCasesWithS=nCasesWithS,
             VEoverall=VEoverall, risk0=risk0, PlatVElowest=PlatVElowest,
             VElowest=VElowest, M=M, alpha=alpha, sigma2obs=sigma2obs,
             rho=rho, biomType=biomType, cohort=cohort, p=p)


## Continuous biomarker, saving output, varying sample sizes ##

nCases <- 32
nControls <- 1000
nCasesWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=20)
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "continuous"
saveDir <- "~/myDir"
saveFile <- "MyFile"
computePower(nCases=nCases, nCasesWithS=nCasesWithS, nControls=nControls,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall,
             risk0=risk0, PlatVElowest=PlatVElowest, VElowest=VElowest,
             M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho,
             biomType=biomType, saveDir=saveDir, saveFile=saveFile)
}

}
\seealso{
\code{\link{computeN}}, \code{\link{plotPowerTri}}, \code{\link{plotPowerCont}}
}
