% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCodeUse.R
\name{tableCohortCodeUse}
\alias{tableCohortCodeUse}
\title{Format the result of summariseCohortCodeUse into a table.}
\usage{
tableCohortCodeUse(
  result,
  type = "gt",
  header = c("cdm_name", "estimate"),
  splitStrata = TRUE,
  conceptId = TRUE,
  sourceConcept = TRUE,
  timing = FALSE,
  groupColumns = NULL,
  excludeColumns = c("result_id", "estimate_type", "additional_name", "additional_level"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised result with results of the type "cohort_code_use".}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: \code{cdm_name}, \code{group}, \code{strata}, \code{additional},
\code{variable}, \code{estimate}, \code{settings}.}

\item{splitStrata}{If TRUE strata will be split.}

\item{conceptId}{If TRUE concept ids will be displayed.}

\item{sourceConcept}{If TRUE source concepts will be displayed.}

\item{timing}{If TRUE the timing setting will be displayed.}

\item{groupColumns}{Columns to use as group labels. Allowed columns are
\code{cdm_name}, \code{cohort_name} and/or \code{codelist_name}.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
visOmopResults::optionsVisOmopTable() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseCohortCodeUse
result.
}
\description{
Format the result of summariseCohortCodeUse into a table.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(),
                      dbdir = CDMConnector::eunomia_dir())
cdm <- CDMConnector::cdm_from_con(con,
                                  cdm_schem = "main",
                                  write_schema = "main")
cdm <- CDMConnector::generateConceptCohortSet(cdm = cdm,
conceptSet = list(a = 260139,
                  b = 1127433),
                  name = "cohorts",
                  end = "observation_period_end_date",
                  overwrite = TRUE)

results_cohort_mult <-
summariseCohortCodeUse(list(cs = c(260139,19133873)),
                      cdm = cdm,
                      cohortTable = "cohorts",
                      timing = "entry")

tableCohortCodeUse(results_cohort_mult)
CDMConnector::cdmDisconnect(cdm)
}

}
