% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetOnIngredientRange.R
\name{subsetOnIngredientRange}
\alias{subsetOnIngredientRange}
\title{Subset a codelist to only those codes with a range of number of ingredients}
\usage{
subsetOnIngredientRange(x, cdm, ingredientRange, negate = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{ingredientRange}{Used to restrict descendant codes to those
associated with a specific number of drug ingredients. Must be a vector of
length two with the first element the minimum number of ingredients allowed
and the second the maximum. A value of c(2, 2) would restrict to only
concepts associated with two ingredients.}

\item{negate}{If FALSE, only concepts with the ingredient range specified will be
returned (both limits included). If TRUE, concepts with number of ingredients outside
the range will be returned.}
}
\value{
The codelist with only those concepts associated with the domain
(if negate = FALSE) or the codelist without those concepts associated with
the domain (if negate = TRUE).
}
\description{
Subset a codelist to only those codes with a range of number of ingredients
}
\examples{
\donttest{
library(CodelistGenerator)
library(omopgenerics)
cdm <- mockVocabRef()
codes <- subsetOnIngredientRange(
              x = newCodelist(list("codes" = c(10L, 13L))),
              cdm = cdm,
              ingredientRange = c(2, 10))
codes
}
}
