% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetOnVocabulary.R
\name{subsetOnVocabulary}
\alias{subsetOnVocabulary}
\title{Subset a codelist to only those codes from a particular vocabulary.}
\usage{
subsetOnVocabulary(x, cdm, vocabulary, negate = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{vocabulary}{Vocabulary to subset with (i.e., SNOMED)}

\item{negate}{If FALSE, only concepts with the vocabulary specified will be
returned. If TRUE, concepts with the vocabulary specified will be excluded.}
}
\value{
The codelist with only those concepts associated with the vocabulary
(if negate = FALSE) or the codelist without those concepts associated with
the vocabulary (if negate = TRUE).
}
\description{
Subset a codelist to only those codes from a particular vocabulary.
}
\examples{
\donttest{
library(CodelistGenerator)
library(omopgenerics)
cdm <- mockVocabRef()
codes <- subsetOnVocabulary(
              x = newCodelist(list("codes" = c(1L,13L,15L))),
              cdm = cdm,
              vocabulary = "SNOMED")
codes
}
}
