% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireIsFirstEntry.R
\name{requireIsLastEntry}
\alias{requireIsLastEntry}
\title{Restrict cohort to last entry per person}
\usage{
requireIsLastEntry(
  cohort,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Column name in cohort that contains the date to restrict on.}

\item{name}{Name of the new cohort with the restriction.}
}
\value{
A cohort table in a cdm reference.
}
\description{
\code{requireIsLastEntry()} filters cohort records, keeping only the last
cohort entry per person.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 <- requireIsLastEntry(cdm$cohort1)
}

}
