% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortSurvival.R
\name{addCohortSurvival}
\alias{addCohortSurvival}
\title{Add survival information to a cohort table}
\usage{
addCohortSurvival(
  x,
  cdm,
  outcomeCohortTable,
  outcomeCohortId = 1,
  outcomeDateVariable = "cohort_start_date",
  outcomeWashout = Inf,
  censorOnCohortExit = FALSE,
  censorOnDate = NULL,
  followUpDays = Inf
)
}
\arguments{
\item{x}{cohort table to add survival information}

\item{cdm}{CDM reference}

\item{outcomeCohortTable}{The outcome cohort table of interest.}

\item{outcomeCohortId}{ID of event cohorts to include. Only one outcome
(and so one ID) can be considered.}

\item{outcomeDateVariable}{Variable containing date of outcome event}

\item{outcomeWashout}{Washout time in days for the outcome}

\item{censorOnCohortExit}{If TRUE, an individual's follow up will be
censored at their cohort exit}

\item{censorOnDate}{if not NULL, an individual's follow up will be censored
at the given date}

\item{followUpDays}{Number of days to follow up individuals (lower bound 1,
upper bound Inf)}
}
\value{
Two additional columns will be added to x. The "time" column will
contain number of days to censoring. The "status" column will indicate
whether the patient had the event (value: 1), or did not have the event
(value: 0)
}
\description{
Add survival information to a cohort table
}
\examples{
\donttest{

cdm <- mockMGUS2cdm()
cdm$mgus_diagnosis <- cdm$mgus_diagnosis \%>\%
  addCohortSurvival(
    cdm = cdm,
    outcomeCohortTable = "death_cohort",
    outcomeCohortId = 1
  )
  }

}
