% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson_Regression.R
\name{PoissonCurveSolver}
\alias{PoissonCurveSolver}
\title{Calculates the likelihood curve for a poisson model directly}
\usage{
PoissonCurveSolver(
  df,
  pyr0 = "pyr",
  event0 = "event",
  names = c("CONST"),
  term_n = c(0),
  tform = "loglin",
  keep_constant = c(0),
  a_n = c(0),
  modelform = "M",
  control = list(),
  strat_col = "null",
  model_control = list(),
  cons_mat = as.matrix(c(0)),
  cons_vec = c(0)
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{pyr0}{column used for person-years per row}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{strat_col}{column to stratify by if needed}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}

\item{cons_mat}{Matrix containing coefficients for a system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for a system of linear constraints, formatted as vector}
}
\value{
returns a list of the final results
}
\description{
\code{PoissonCurveSolver} solves the confidence interval for a poisson model, starting at the optimum point and
iteratively optimizing each point to using the bisection method
}
\seealso{
Other Poisson Wrapper Functions: 
\code{\link{RunPoissonEventAssignment}()},
\code{\link{RunPoissonEventAssignment_bound}()},
\code{\link{RunPoissonRegression}()},
\code{\link{RunPoissonRegression_Guesses_CPP}()},
\code{\link{RunPoissonRegression_Joint_Omnibus}()},
\code{\link{RunPoissonRegression_Omnibus}()},
\code{\link{RunPoissonRegression_Residual}()},
\code{\link{RunPoissonRegression_Single}()},
\code{\link{RunPoissonRegression_Strata}()},
\code{\link{RunPoissonRegression_Tier_Guesses}()}
}
\concept{Poisson Wrapper Functions}
