/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class HeavyWeightContainer
extends Panel {
    private Image bufferImage;
    private boolean doubleBuffer = false;

    public HeavyWeightContainer(Component component) {
        this(component, false);
    }

    public HeavyWeightContainer(Component component, boolean bl) {
        super(new BorderLayout());
        this.doubleBuffer = bl;
        this.add(component, "Center");
    }

    public void invalidate() {
        super.invalidate();
        this.bufferImage = null;
    }

    public void update(Graphics graphics) {
        if (this.doubleBuffer) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffer;
    }

    public void paint(Graphics graphics) {
        if (this.doubleBuffer) {
            if (this.bufferImage == null) {
                this.bufferImage = this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics graphics2 = this.bufferImage.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics2);
            graphics.drawImage(this.bufferImage, 0, 0, null);
            graphics2.dispose();
        } else {
            super.paint(graphics);
        }
    }
}

