/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import net.infonode.docking.DockingWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowTab;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.hover.TabbedPanelTitledTabHoverAction;
import net.infonode.tabbedpanel.hover.TitledTabTabbedPanelHoverAction;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TabWindowHoverAction
implements HoverListener {
    private TabbedPanelProperties tabbedPanelProperties;
    private TitledTabProperties titledTabProperties;
    private ViewTitleBarProperties viewTitleBarProperties;
    private TabbedPanelTitledTabHoverAction tpTabAction;
    private TitledTabTabbedPanelHoverAction tabTpAction;
    private boolean titleBarPropsAdded = false;
    private TabListener tabListener = new TabAdapter(){

        public void tabSelected(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getTab() != null) {
                DockingWindow dockingWindow = ((WindowTab)tabStateChangedEvent.getTab()).getWindow();
                if (!TabWindowHoverAction.this.titleBarPropsAdded && dockingWindow instanceof View) {
                    TabWindowHoverAction.this.addViewTitleBarProperties((View)dockingWindow);
                }
            }
        }

        public void tabDeselected(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getTab() != null) {
                DockingWindow dockingWindow = ((WindowTab)tabStateChangedEvent.getTab()).getWindow();
                if (TabWindowHoverAction.this.titleBarPropsAdded && dockingWindow instanceof View) {
                    TabWindowHoverAction.this.removeViewTitleBarProperties((View)dockingWindow);
                }
            }
        }
    };

    public TabWindowHoverAction() {
        this(new TabbedPanelProperties(), new TitledTabProperties(), new ViewTitleBarProperties());
    }

    public TabWindowHoverAction(TabbedPanelProperties tabbedPanelProperties, TitledTabProperties titledTabProperties, ViewTitleBarProperties viewTitleBarProperties) {
        this.tabbedPanelProperties = tabbedPanelProperties;
        this.titledTabProperties = titledTabProperties;
        this.viewTitleBarProperties = viewTitleBarProperties;
        this.tpTabAction = new TabbedPanelTitledTabHoverAction(tabbedPanelProperties, titledTabProperties);
        this.tabTpAction = new TitledTabTabbedPanelHoverAction(titledTabProperties, tabbedPanelProperties);
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public ViewTitleBarProperties getViewTitleBarProperties() {
        return this.viewTitleBarProperties;
    }

    public void mouseEntered(HoverEvent hoverEvent) {
        if (hoverEvent.getSource() instanceof TabbedPanel) {
            DockingWindow dockingWindow;
            TabbedPanel tabbedPanel = (TabbedPanel)hoverEvent.getSource();
            tabbedPanel.addTabListener(this.tabListener);
            if (tabbedPanel.getSelectedTab() != null && (dockingWindow = ((WindowTab)tabbedPanel.getSelectedTab()).getWindow()) instanceof View) {
                this.addViewTitleBarProperties((View)dockingWindow);
            }
            this.tpTabAction.mouseEntered(hoverEvent);
        } else if (hoverEvent.getSource() instanceof TitledTab) {
            WindowTab windowTab = (WindowTab)hoverEvent.getSource();
            windowTab.addTabListener(this.tabListener);
            if (windowTab.isSelected() && windowTab.getWindow() instanceof View) {
                this.addViewTitleBarProperties((View)windowTab.getWindow());
            }
            this.tabTpAction.mouseEntered(hoverEvent);
        }
    }

    public void mouseExited(HoverEvent hoverEvent) {
        if (hoverEvent.getSource() instanceof TabbedPanel) {
            DockingWindow dockingWindow;
            TabbedPanel tabbedPanel = (TabbedPanel)hoverEvent.getSource();
            tabbedPanel.removeTabListener(this.tabListener);
            if (this.titleBarPropsAdded && tabbedPanel.getSelectedTab() != null && (dockingWindow = ((WindowTab)tabbedPanel.getSelectedTab()).getWindow()) instanceof View) {
                this.removeViewTitleBarProperties((View)dockingWindow);
            }
            this.tpTabAction.mouseExited(hoverEvent);
        } else if (hoverEvent.getSource() instanceof TitledTab) {
            WindowTab windowTab = (WindowTab)hoverEvent.getSource();
            windowTab.removeTabListener(this.tabListener);
            if (this.titleBarPropsAdded && windowTab.getWindow() instanceof View) {
                this.removeViewTitleBarProperties((View)windowTab.getWindow());
            }
            this.tabTpAction.mouseExited(hoverEvent);
        }
    }

    private void addViewTitleBarProperties(View view) {
        view.getViewProperties().getViewTitleBarProperties().addSuperObject(this.viewTitleBarProperties);
        this.titleBarPropsAdded = true;
    }

    private void removeViewTitleBarProperties(View view) {
        view.getViewProperties().getViewTitleBarProperties().removeSuperObject(this.viewTitleBarProperties);
        this.titleBarPropsAdded = false;
    }
}

