/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.gui.icon.button.CloseIcon;

public class CloseOthersWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final CloseOthersWindowAction INSTANCE = new CloseOthersWindowAction();
    private static final Icon icon = new CloseIcon(10);

    private CloseOthersWindowAction() {
    }

    public Icon getIcon() {
        return icon;
    }

    public String getName() {
        return "Close Others";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        return dockingWindow.getWindowParent() instanceof AbstractTabWindow;
    }

    public void perform(DockingWindow dockingWindow) {
        if (this.isPerformable(dockingWindow)) {
            AbstractTabWindow abstractTabWindow = (AbstractTabWindow)dockingWindow.getWindowParent();
            int n = 0;
            while (n < abstractTabWindow.getChildWindowCount()) {
                if (abstractTabWindow.getChildWindow(n) != dockingWindow && abstractTabWindow.getChildWindow(n).isClosable()) {
                    try {
                        abstractTabWindow.getChildWindow(n).closeWithAbort();
                    }
                    catch (OperationAbortedException operationAbortedException) {
                        ++n;
                    }
                    continue;
                }
                ++n;
            }
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

