% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodepath.R
\name{nodepath}
\alias{nodepath}
\title{Path of a terminal node}
\usage{
nodepath(termnode, Tree)
}
\arguments{
\item{termnode}{The terminal node of which the path has to be extracted}

\item{Tree}{An object of the class "ranktree"}
}
\value{
The path leading to the terminal node
}
\description{
Given an object of the class "ranktree", it visualize the path leading to the terminal node
}
\examples{
\donttest{
data(Irish)
#build the tree with default options
tree <- ranktree(Irish$rankings,Irish$predictors)
#get information about all the paths leading to terminal nodes
paths <- treepaths(tree)
#see the path for terminal node number 8
nodepath(termnode=8,tree)
}
 
}
\seealso{
\code{\link{ranktree}}, \code{\link{treepaths}}, \code{\link{getsubtree}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
