% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{adj_conv}
\alias{adj_conv}
\title{Convert adjacency function to the affinity matrix}
\usage{
adj_conv(adj.mat, alpha = 1)
}
\arguments{
\item{adj.mat}{Adjacency matrix. The elements must be within [-1, 1].}

\item{alpha}{soft threshold value (see details).}
}
\value{
the matrix if affinity values.
}
\description{
Convert adjacency function to the affinity matrix
}
\details{
adj = exp(-(1-adj)^2/(2*alpha^2))
ref: Luxburg (2007), "A tutorial on spectral clustering", Stat Comput
}
\examples{
Adj_mat = rbind(c(0.0,0.9,0.0),
                c(0.9,0.0,0.2),
                c(0.0,0.2,0.0))
adj_conv(Adj_mat)


}
