% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_coordinated_groups.R
\name{detect_coordinated_groups}
\alias{detect_coordinated_groups}
\title{detect_coordinated_groups}
\usage{
detect_coordinated_groups(x, time_window = 10, min_repetition = 2)
}
\arguments{
\item{x}{a data.table with the columns: \code{object_id} (uniquely identifies
coordinated content), \code{id_user} (unique ids for users), \code{content_id}
(id of user generated content), \code{timestamp_share} (integer)}

\item{time_window}{the number of seconds within which shared contents
are to be considered as coordinated (default to 10 seconds).}

\item{min_repetition}{the minimum number of repeated coordinated
action to define two users as coordinated (defaults to 2)}
}
\value{
a data.table with ids of coordinated contents. Columns:
\code{object_id}, \code{id_user}, \code{id_user_y}, \code{content_id}, \code{content_id_y},
\code{timedelta}. The \code{id_user} and \code{content_id} represent the "older"
data points, \code{id_user_y} and \code{content_id_y} represent the "newer"
data points. For example, User A retweets from User B, then User A's
content is newer (i.e., \code{id_user_y}).
}
\description{
Function to detect coordinated behaviour based on content groups.
See details.
}
\details{
The function groups the data by \code{object_id} (uniquely identifies
coordinated content) and calculates the time differences between all
\code{content_id} (ids of user generated contents) within their groups.
It then filters out all \code{content_id} that are higher than the \code{time_window}
(in seconds). It returns a \code{data.table} with all IDs of coordinated
contents. The \code{object_id} can be for example: hashtags, IDs of tweets being
retweeted, or URLs being shared.
}
