% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcceptAffCI.R
\name{AcceptAffCI}
\alias{AcceptAffCI}
\title{Acceptability Interval}
\usage{
AcceptAffCI(x, marg, lev, CPint)
}
\arguments{
\item{x}{integer co-occurrence count that should properly fall within the closed interval [max(0,mA+mB-N), min(mA,mB)]}

\item{marg}{a 3-entry integer vector (mA,mB,N) consisting of the first row and column totals and the table total for a 2x2 contingency table}

\item{lev}{a confidence level, generally somewhere from 0.8 to 0.95  (default 0.95)}

\item{CPint}{the exact conservative ("Clopper-Pearson-type") interval CI.CP calculated in the function AlphInts()}
}
\value{
This function returns the "Acceptability Interval" of Blaker (2000). The code is adapted from Blaker's Splus code for the case of an unknown binomial proportion.
}
\description{
This function calculates the "Acceptability Interval" of Blaker for the log-odds parameter alpha in the Extended Hypergeometric distribution.
}
\details{
This function calculates the "Acceptability Interval" based on "Acceptability Function" computed by AcceptAffin().
This interval, developed by Blaker (2000), was proved in that paper's Theorem 1 in a more general class of estimation problems
to have three essential properties: it falls within the CI.CP confidence interval; it maintains the property of being conservative,
i.e., of having coverage probability under the Extended Hypergeometric (mA,mB,N, alpha) distribution at least as large as the nominal level;
and it is larger when the confidence level is larger.
}
\examples{
auxCP = AlphInts(30,c(50,80,120), lev=0.9)$CI.CP
AcceptAffCI(30,c(50,80,120), 0.9, auxCP)

AlphInts(30,c(50,80,120), lev=0.9)$CI.Blaker
}
\references{
Blaker, H. (2000), “Confidence curves and improved exact confidence intervals for discrete distributions", Canadian Journal of Statistics 28, 783-798.
}
\author{
Eric Slud
}
