% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidCoreCoverConcept.R
\name{drawCentroidCoreCover}
\alias{drawCentroidCoreCover}
\title{draw centroid of core cover for 3 or 4 players}
\usage{
drawCentroidCoreCover(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "centroid of core cover")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCentroidCoreCover draws the centroid of the core cover for 3 or 4 players.
}
\examples{
library(CoopGame)
v <-c(1,2,3,60,60,60,142)
drawCentroidCoreCover(v,colour="black")

}
\references{
Tijs S.H. and Lipperts F.A.S. (1982) "The hypercube and the core cover of n-person cooperative games", Cahiers du Centre d' Etudes de Researche Operationelle 24, pp. 27--37

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 45--46
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
