% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_scmprisk_sp_copula_pen.R
\name{rc_scmprisk_sp_copula_pen}
\alias{rc_scmprisk_sp_copula_pen}
\title{Penalized copula regression models with Cox semiparametric margins for semi-competing risk data under right-censoring.}
\source{
Tao Sun, Weijie Liang, Gongzi Zhang, Danhui Yi, Ying Ding, Lihai Zhang (2023+). Penalized semiparametric
copula method for semi-competing risks data: Application to hip fracture in elderly. JRSSC.
}
\usage{
rc_scmprisk_sp_copula_pen(
  data,
  var_list1,
  var_list2,
  m1,
  m2,
  initial,
  a,
  b,
  pen1,
  pen2,
  copula
)
}
\arguments{
\item{data}{a data frame; must have \code{id} (subject id), \code{ind} (1,2 for two margins),
\code{obs_time}, \code{status} (0 for right-censoring, 1 for event).}

\item{var_list1}{the list of covariates to be fitted into the copula model for non-terminal event.}

\item{var_list2}{the list of covariates to be fitted into the copula model for terminal event.}

\item{m1}{integer, degree of Bernstein polynomials for non-terminal event; default is 3.}

\item{m2}{integer, degree of Bernstein polynomials for terminal event; default is 3.}

\item{initial}{a vector of initial values for all parameters, including phi1 and phi2
(two Bernstein polynomials parameters), beta1 and beta2 (regression coefficients in Cox margins),
\code{eta} (copula parameters).}

\item{a}{Tuning parameters in penalty function for non-terminal event.}

\item{b}{Tuning parameters in penalty function for terminal event.}

\item{pen1}{Types of penalty function for non-terminal event, including \code{"NOPEN"}, \code{"RIDGE"},
\code{"BAR"}, \code{"LASSO"}, \code{"MCP"}, \code{"SCAD"}.}

\item{pen2}{Types of penalty function for terminal event, including \code{"NOPEN"}, \code{"RIDGE"},
\code{"BAR"}, \code{"LASSO"}, \code{"MCP"}, \code{"SCAD"}.}

\item{copula}{Types of copula, including \code{"Clayton"}, \code{"Gumbel"}.}
}
\value{
parameter estimates and BIC
}
\description{
Fits a penalized copula model with Cox semiparametric margins for semi-competing risk data under right-censoring.
}
\examples{
\dontrun{
data("data_sim_scmprisk_vs")
var_list = paste0('x',seq(1,5,1))
phi1_ini = c(0,0,0,0)
phi2_ini = c(0,0,0,0)
beta1_ini = c(0,0,0,0,0)
beta2_ini = c(0,0,0,0,0)
eta_ini = 1
initial = c(phi1_ini,phi2_ini,beta1_ini, beta2_ini, eta_ini)
# obtain initial parameter estimates by ridge penalty
fit0 = rc_scmprisk_sp_copula_pen(data=data_sim_scmprisk_vs,
                                 var_list1 = var_list, var_list2 = var_list,
                                 m1=3, m2=3, initial=initial,
                                 a=0.1, b=0.1, pen1='RIDGE', pen2='RIDGE',
                                 copula='Clayton')
est_ini = c(fit0$Est_phi1,fit0$Est_phi2,fit0$Est_beta1,fit0$Est_beta2,fit0$Est_eta)

fit = rc_scmprisk_sp_copula_pen(data=data_sim_scmprisk_vs,
                                var_list1 = var_list, var_list2 = var_list,
                                m1=3, m2=3, initial=est_ini,
                                a=0.2, b=0.2, pen1='MCP', pen2='MCP',
                                copula='Clayton')
fit$Est_beta1
fit$Est_beta2
}
}
