% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summarycopula}
\alias{summarycopula}
\title{Print a summary of the fitted model.}
\usage{
summarycopula(object, digits = 3, ...)
}
\arguments{
\item{object}{An object from \link{fitcopula}.}

\item{digits}{An optional positive value to control the number of digits to print when printing numeric values.}

\item{...}{other \link[rstan]{stan} options.}
}
\value{
The posterior mean and 95 percent credible intervals, n_eff, Rhat and WAIC.
}
\description{
Print a summary of the fitted model.
}
\examples{

data(ascus)
\dontrun{
fit <- fitcopula(data=ascus,
         SID = "StudyID",
         formula.se= StudyID ~ Test,
         seed=3,
         copula="fgm")

ss <- summarycopula(object=fit)

ss <- summary(fit$model)

}
}
\author{
Victoria N Nyaga
}
\references{
{Watanabe S (2010). Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion in Singular
Learning Theory. Journal of Machine Learning Research, 11, 3571-3594.}

{Vehtari A, Gelman A (2014). WAIC and Cross-validation in Stan. Unpublished, pp. 1-14.}
}

