% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localInterface.R
\name{LocalInterface}
\alias{LocalInterface}
\alias{invokeFromR}
\alias{cs.in.auxiliaries}
\alias{cs.in.brushed}
\alias{cs.in.dataset}
\alias{cs.in.excluded}
\alias{cs.in.groupvars}
\alias{cs.in.predictors}
\alias{cs.in.responses}
\alias{cs.in.scriptvars}
\alias{cs.in.subsets}
\alias{cs.in.subsets.current}
\alias{cs.quote}
\alias{cs.out.dataset}
\alias{cs.out.emf}
\alias{cs.out.png}
\title{Local Interface Functions}
\usage{
invokeFromR()

cs.in.auxiliaries(quote = FALSE)

cs.in.brushed()

cs.in.dataset()

cs.in.excluded()

cs.in.groupvars(quote = FALSE)

cs.in.predictors(quote = FALSE)

cs.in.responses(quote = FALSE)

cs.in.scriptvars(name = NA)

cs.in.subsets()

cs.in.subsets.current()

cs.quote(x)

cs.out.dataset(data, name = NA, brush = FALSE)

cs.out.emf(name = NULL, width = 10, height = 10)

cs.out.png(name = NULL, width = 10, height = 10)
}
\arguments{
\item{quote}{[\code{logical(1)}]\cr
Quote all variables to cover invalid names.
Use \code{\link[base]{make.names}} as an alternative.}

\item{name}{[\code{character(1)}]\cr
Name for the output to Cornerstone.}

\item{x}{[\code{character(1)}]\cr
String to check for invalid characters related to \code{\link[base]{make.names}}.
Add backticks, if necessary.}

\item{data}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{brush}{[\code{logical(1)}]\cr
Brushing of the output dataset in Cornerstone across the R object.}

\item{width}{[\code{numeric(1)}]\cr
Width of the exported plotting object. See \code{\link[grDevices]{pdf}}.}

\item{height}{[\code{numeric(1)}]\cr
Width of the exported plotting object. See \code{\link[grDevices]{pdf}}.}
}
\description{
CS-R interface functions are defined in package namespace via this file. Each function
  overwrites itself with the corresponding counterpart defined in the global environment
  from CS.
}
