% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBData.R, R/CMData.R, R/aaa-generics.R
\name{unwrap.CBData}
\alias{unwrap.CBData}
\alias{unwrap.CMData}
\alias{unwrap}
\title{Unwrap a clustered object}
\usage{
\method{unwrap}{CBData}(object, ...)

\method{unwrap}{CMData}(object, ...)

unwrap(object, ...)
}
\arguments{
\item{object}{a \code{\link{CBData}} object}

\item{\dots}{other potential arguments; not currently used}
}
\value{
For \code{unwrap.CMData}: a data frame with one row for each cluster element (having a multinomial
outcome) with the following standardized column names

\item{Trt}{factor, the treatment group}

\item{ClusterSize}{numeric, the cluster size}

\item{ID}{factor, each level representing a different cluster}

\item{Resp}{numeric with integer values giving the response type of the cluster
element}

For \code{unwrap.CBData}: a data frame with one row for each cluster element (having a binary
outcome) with the following standardized column names

\item{Trt}{factor, the treatment group}

\item{ClusterSize}{numeric, the cluster size}

\item{ID}{factor, each level representing a different cluster}

\item{Resp}{numeric with 0/1 values, giving the response of the cluster
element}
}
\description{
\code{unwrap} is a utility function that reformats a CBData or CMData object so
that each row is one observation (instead of one or more clusters). A new
`ID' variable is added to indicate clusters. This form can be useful for
setting up the data for a different package.
}
\examples{

data(dehp)
dehp.long <- unwrap(dehp)
head(dehp.long)


data(shelltox)
ush <- unwrap(shelltox)
head(ush)

}
\author{
Aniko Szabo
}
\keyword{manip}
