% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.covregrf.R
\name{print.covregrf}
\alias{print.covregrf}
\title{Print summary output of a CovRegRF analysis}
\usage{
\method{print}{covregrf}(x, ...)
}
\arguments{
\item{x}{An object of class \code{(covregrf, grow)}, \code{(covregrf, predict)}
or \code{(covregrf, significancetest)}.}

\item{...}{Optional arguments to be passed to other methods.}
}
\value{
Returns a \code{character} string for the summary of CovRegRF
  analysis.
}
\description{
Print summary output of a CovRegRF analysis. This is the default print method
  for the package.
}
\examples{
\donttest{
## load generated example data
data(data, package = "CovRegRF")
xvar.names <- colnames(data$X)
yvar.names <- colnames(data$Y)
data1 <- data.frame(data$X, data$Y)

## define train/test split
set.seed(2345)
smp <- sample(1:nrow(data1), size = round(nrow(data1)*0.6), replace = FALSE)
traindata <- data1[smp,,drop=FALSE]
testdata <- data1[-smp, xvar.names, drop=FALSE]

## formula object
formula <- as.formula(paste(paste(yvar.names, collapse="+"), ".", sep=" ~ "))

## train covregrf
covregrf.obj <- covregrf(formula, traindata, params.rfsrc = list(ntree = 50))

## print the grow object
print(covregrf.obj)

## predict with new test data
pred.obj <- predict(covregrf.obj, newdata = testdata)

## print the predict object
print(pred.obj)
}
}
