\name{datf}
\alias{datf}
\docType{data}
\title{ Simulated Data, Factors}
\description{This data is simulated. The covariates, X, and the treatment, T, are all generated by simulating from a multivariate normal distribution and then dichotomizing to get binary variables with a certain dependence structure.The code generating the data is \cr
\cr
\code{library(mvtBinaryEP)}\cr
\code{set.seed(9327529)}\cr
\code{n<-500}\cr
\code{eta<-mvrnorm(n,rep(0,2),diag(1,2,2))}\cr
\code{R<-diag(1,9,9)}\cr
\code{R[1:3,9]<-R[9,1:3]<-0.33} \cr
\code{R[4:5,9]<-R[9,4:5]<-0.23}\cr
\code{R[8,9]<-R[9,8]<-0.27}\cr
\code{R[2,5]<-R[5,2]<-R[3,4]<-R[4,3]<-0.71}\cr
\code{ep0<-ep(mu=c(rep(0.5,9)), R=R, nRep=n)}\cr
\code{X<-ep0$y[,1:8]}\cr
\code{T<-ep0$y[,9]}\cr
\code{y0<-4+2*X[,1]+3*X[,4]+5*X[,5]+2*X[,6]+eta[,1]}\cr
\code{y1<-2+2*X[,1]+3*X[,4]+5*X[,5]+2*X[,6]+eta[,2]}\cr
\code{y<-y1*T+y0*(1-T)}\cr
\code{datf<-data.frame(x1=X[,1],x2=X[,2],x3=X[,3],x4=X[,4],x5=X[,5],x6=X[,6],x7=X[,7],}\cr
\code{x8=X[,8],y0,y1,y,T)}\cr
\code{datf[,1:8]<-lapply(datf[,1:8],as.factor)}
}

\usage{data(datf)}
\format{
  A data frame with 500 observations on the following 12 variables.
  \describe{
    \item{\code{x1  }}{a factor with two levels}
    \item{\code{x2  }}{a factor with two levels}
    \item{\code{x3  }}{a factor with two levels}
    \item{\code{x4  }}{a factor with two levels}
    \item{\code{x5  }}{a factor with two levels}
    \item{\code{x6  }}{a factor with two levels}
    \item{\code{x7  }}{a factor with two levels}
    \item{\code{x8  }}{a factor with two levels}
    \item{\code{y0  }}{a numeric vector}
    \item{\code{y1  }}{a numeric vector}
    \item{\code{y   }}{a numeric vector}
    \item{\code{T  }}{a numeric vector}
  }
}
