% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_records.R
\name{odk2openVA}
\alias{odk2openVA}
\title{Map VA records to coding algorithms in openVA package: InterVA5 and InSilico (with option data.type = "WHO2016").}
\usage{
odk2openVA(odk)
}
\arguments{
\item{odk}{A dataframe, obtained from reading an ODKBriefcase
export of records collected with the WHO questionnaire.}
}
\description{
\code{odk2openVA} transform data collected with the 2016 WHO VA  instrument (version 1.4.1)
  to serve different InterVA5 and InSilicoVA alogrithms for coding cause of death.
}
\examples{
\dontrun{
records <- read.csv('who_va_output.csv')
output_data_IV5 <- odk2InterVA5(records)
}

}
