% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.ConfMatrix.R
\name{ConfMatrix}
\alias{ConfMatrix}
\title{Confusion matrix wrapper.}
\description{
Creates a \code{\link{R6}} confusion matrix from the
\code{\link[caret]{confusionMatrix}} caret package.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{MeasureFunction}},
\code{\link{ClassificationOutput}}
}
\keyword{classif}
\keyword{math}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConfMatrix-new}{\code{ConfMatrix$new()}}
\item \href{#method-ConfMatrix-getConfusionMatrix}{\code{ConfMatrix$getConfusionMatrix()}}
\item \href{#method-ConfMatrix-getTP}{\code{ConfMatrix$getTP()}}
\item \href{#method-ConfMatrix-getTN}{\code{ConfMatrix$getTN()}}
\item \href{#method-ConfMatrix-getFN}{\code{ConfMatrix$getFN()}}
\item \href{#method-ConfMatrix-getFP}{\code{ConfMatrix$getFP()}}
\item \href{#method-ConfMatrix-clone}{\code{ConfMatrix$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-new}{}}}
\subsection{Method \code{new()}}{
Method to create a confusion matrix object from a
\code{caret} \code{\link[caret]{confusionMatrix}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$new(confMatrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{confMatrix}}{A \code{caret} \link[caret]{confusionMatrix} argument.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-getConfusionMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-getConfusionMatrix}{}}}
\subsection{Method \code{getConfusionMatrix()}}{
The function obtains the \code{\link[caret]{confusionMatrix}}
following the same structured as defined in the \code{caret} package
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$getConfusionMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link[caret]{confusionMatrix}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-getTP"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-getTP}{}}}
\subsection{Method \code{getTP()}}{
The function is used to compute the number of True Positive
values achieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$getTP()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-getTN"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-getTN}{}}}
\subsection{Method \code{getTN()}}{
The function computes the True Negative values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$getTN()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-getFN"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-getFN}{}}}
\subsection{Method \code{getFN()}}{
The function returns the number of Type II errors
(False Negative).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$getFN()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-getFP"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-getFP}{}}}
\subsection{Method \code{getFP()}}{
The function returns the number of Type I errors
(False Negative).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$getFP()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConfMatrix-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConfMatrix-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConfMatrix$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
