% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskFiles.R
\name{saveReportXls}
\alias{saveReportXls}
\title{Save R object in binary file.}
\usage{
saveReportXls(
  x,
  task,
  type,
  ext = "xlsx",
  subdir = NULL,
  dirCreate = TRUE,
  AdjWidth = TRUE,
  FreezeRow = 1,
  FreezeCol = 3,
  metadata = "metadata",
  metadata.append = NULL,
  ...
)
}
\arguments{
\item{x}{object to save. It can be either a data frame, an object of type \code{AnnotatedDataFrame}, or a list thereof.}

\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{Filename type. If the type is an array, the cocatenation of the elements is used with separator"-". Filenames have the form [task name]_[type].[ext]}

\item{ext}{Filename extension.}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{AdjWidth}{If \code{TRUE}, will adjust the worksheet column
        widths based upon the longest entry in each column. This is
        approximate.}

\item{FreezeRow}{Rows including this row and above this row will be
        frozen and not scroll. The default value of \code{0} will scroll
	the entire sheet. Note that not all spreadsheet applications
	support this feature.}

\item{FreezeCol}{Columns including this column and to the left of this
        column will be frozen and not scroll. The default value of
	\code{0} will scroll the entire sheet. Note that not all
	spreadsheet applications support this feature.}

\item{metadata}{prefix for names of worksheets holding metadata.}

\item{metadata.append}{array of metadata field names to be appended in header of tables.}

\item{...}{
  Arguments passed on to \code{\link[WriteXLS:WriteXLS]{WriteXLS::WriteXLS}}
  \describe{
    \item{\code{ExcelFileName}}{The name of the Excel file to be created.
        If the file extension is \emph{.XLS}, an Excel 2003 file will be
        created. If the file extension is \emph{.XLSX}, an Excel 2007
	file will be created.
        Must be a valid Excel filename. May include an existing path.
        \code{normalizePath} is used to support tilde expansion, etc.}
    \item{\code{SheetNames}}{A character vector containing the names of each worksheet
        to be created. If \code{NULL} (the default), the
        names of the dataframes will be used instead. Worksheet names may
        be up to 31 characters in length and must be unique. If
        specified, \code{length(SheetNames)} must be the same as
        \code{length(x)}. NOTE: The order of the names here must match
        the order of the data frames as listed in \code{x}.}
    \item{\code{perl}}{Name of the perl executable to be called.}
    \item{\code{verbose}}{Output step-by-step status messages during the creation
        of the Excel file. Default is FALSE.}
    \item{\code{Encoding}}{Define the character encoding to be used for the
        exported data frames. Defaults to \code{UTF-8}.}
    \item{\code{AllText}}{If \code{TRUE}, all cell contents of the Excel file will
        be written as text. Default is FALSE. See Details.}
    \item{\code{row.names}}{If \code{TRUE}, the row names of the data frames are
    included in the Excel file worksheets.}
    \item{\code{col.names}}{If \code{TRUE}, the column names of the data frames are
    included in the Excel file worksheets.}
    \item{\code{AutoFilter}}{If \code{TRUE}, will add autofiltering to each
        column in each worksheet. Note that not all spreadsheet applications
        support this feature.}
    \item{\code{BoldHeaderRow}}{If \code{TRUE}, will apply a bold font to the
        header row for each worksheet.}
    \item{\code{ReadOnly}}{If \code{TRUE}, each worksheet will be set to Read Only
       (Protected mode) to prevent inadvertent changes to the contents when
       the file is opened in Excel or a compatible application. See Details.}
    \item{\code{na}}{The string to use for missing values in the data. Defaults
    to ""}
    \item{\code{envir}}{The environment in which to look for the data frames
       named in \code{x}. This defaults to the environment in which
       \code{WriteXLS} was called.}
  }}
}
\value{
the file name invisibly.
}
\description{
Save R object in binary file.
}
