% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pars.R
\name{are_area_pars}
\alias{are_area_pars}
\title{Test if list has area parameters}
\usage{
are_area_pars(area_pars)
}
\arguments{
\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}
}
\value{
Boolean that indicates if list conforms to expected area parameters
as created by \link{create_area_pars}
}
\description{
Test if list has area parameters
}
\examples{
testit::assert(DAISIE:::are_area_pars(
  create_area_pars(
    max_area = 10,
    current_area = 4,
    proportional_peak_t = 0.5,
    total_island_age = 5,
    sea_level_amplitude = 5,
    sea_level_frequency = 10,
    island_gradient_angle = 0)))
}
\author{
Richel J.C Bilderbeek, Joshua Lambert, Pedro Neves
}
\keyword{internal}
