% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runQvalue.R
\name{runQvalue}
\alias{runQvalue}
\title{Calculate and add q-value and lFDR to dataframe}
\usage{
runQvalue(contrastList, pvalField = "P.Value", ...)
}
\arguments{
\item{contrastList}{A list of dataframes with a p-value column (all tables
must use the same colname for the p-value column.)}

\item{pvalField}{Define the colname of the p-value field in
each dataframe. Not needed if using topTable output. (Optional. Default = "P.Value")}

\item{...}{Optional arguments passed to the qvalue function (See ?qvalue)}
}
\value{
The input contrastList now containing q-value and lFDR columns
  in each dataframe.
}
\description{
Takes an list of contrasts (e.g. topTable output or other dataframes that contain
a p-value column).  Adds a q-value and local FDR (lFDR) column to each dataframe.
}
\details{
The qvalue package from John Storey at Princeton takes a list of p-values and
calculates a q-value and a Local FDR (lFDR). The q-value is essentially a less
conservative FDR estimate compared to the default Benjamini-Hochberg FDR
produced by topTable analysis (i.e. will give more differential genes at
the same nominal cutoff). The q-value function also produces a Local FDR
(lFDR) column which answers a slightly different and possibly more relevant
question. The BH FDR (adj.P.Val in topTable data.frames) and q-value gives
the false discovery rate is for a list of genes at a given threshold.
The local FDR attempts to answer the question: what is the probability that
this particular gene is a false discovery?
See \doi{10.1007/978-3-642-04898-2_248} for a brief introduction
to FDRs and q-values.
}
\examples{
   dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
   contrastList <- DGEobj::getType(dgeObj, type = "topTable")
   contrastList <- lapply(contrastList, dplyr::select,
                          -Qvalue,
                          -qvalue.lfdr)
   colnames(contrastList[[1]])

   contrastList <- runQvalue(contrastList)

   # note new columns added
   colnames(contrastList[[1]])

}
