% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_row_to_string.R
\name{dt_row_to_string}
\alias{dt_row_to_string}
\title{Get the content of a data.table row in print-ready format.}
\usage{
dt_row_to_string(dt, row = 1, sep = ", ", collapse = ": ", quote = "'")
}
\arguments{
\item{dt}{(data.table) The input data.table.}

\item{row}{(int, Optional) Row id to be used. Defaults to 1.}

\item{sep}{a character string to separate the terms.  Not
    \code{\link[base]{NA_character_}}.}

\item{collapse}{an optional character string to separate the results.  Not
    \code{\link[base]{NA_character_}}.}

\item{quote}{(character, Optional) A quote parameter to be applied
to all values of the rows.}
}
\value{
A character string. To print the result, simply forward it to
  print: \code{dt |> dt_row_to_string()}
}
\description{
Create string of the content of a data.table row in
  print-ready format.
}
\examples{
  data.table::data.table(name = "Alice",
                         dob = as.POSIXct("1980-01-01"),
                         sex = "f") |>
    DIZtools::dt_row_to_string()
}
