% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-clustheatmap.R
\name{clustheatmap}
\alias{clustheatmap}
\alias{clustheatmap,DISCBIO-method}
\title{Plotting clusters in a heatmap representation of the cell distances}
\usage{
clustheatmap(
  object,
  clustering_method = "k-means",
  hmethod = "single",
  rseed = NULL,
  quiet = FALSE,
  plot = TRUE
)

\S4method{clustheatmap}{DISCBIO}(
  object,
  clustering_method = "k-means",
  hmethod = "single",
  rseed = NULL,
  quiet = FALSE,
  plot = TRUE
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{clustering_method}{either "k-means" or "model-based" ("k" and "mb" are also accepted)}

\item{hmethod}{Agglomeration method used for determining the cluster order
from hierarchical clustering of the cluster medoids. This should be one of
"ward.D", "ward.D2", "single", "complete", "average". Default is "single".}

\item{rseed}{Random integer to fix random results.}

\item{quiet}{if `TRUE`, intermediary output is suppressed}

\item{plot}{if `TRUE`, plots the heatmap; otherwise, just prints cclmo}
}
\value{
Unless otherwise specified, a heatmap and a vector of the underlying
  cluster order.
}
\description{
This functions plots a heatmap of the distance matrix grouped
  by clusters. Individual clusters are highlighted with rainbow colors along
  the x and y-axes.
}
