% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ERLS.R
\name{ERLS}
\alias{ERLS}
\title{Exponentially Weighted Recursive Least Squares with Missing Value Imputation}
\usage{
ERLS(data, rho = 0.01, lambda = 0.95, nb = 100, niter = 1)
}
\arguments{
\item{data}{Linear regression dataset (1st column as Y, others as X)}

\item{rho}{Regularization parameter}

\item{lambda}{Forgetting factor}

\item{nb}{Maximum iterations}

\item{niter}{Initial iteration count (typically 1)}
}
\value{
List containing:
\item{Yhat}{Imputed response vector}
\item{betahat}{Estimated coefficients}
}
\description{
Exponentially Weighted Recursive Least Squares with Missing Value Imputation
}
\examples{
set.seed(123)
data <- data.frame(
  y = c(rnorm(50), rep(NA, 10)),
  x1 = rnorm(60),
  x2 = rnorm(60)
)
result <- ERLS(data, rho = 0.01, lambda = 0.95, nb = 100, niter = 1)
head(result$Yhat)
}
