% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcSim.R
\name{dmcSim}
\alias{dmcSim}
\title{dmcSim: Run dmc simulation}
\usage{
dmcSim(
  amp = 20,
  tau = 30,
  drc = 0.5,
  bnds = 75,
  resMean = 300,
  resSD = 30,
  aaShape = 2,
  spShape = 3,
  sigm = 4,
  nTrl = 1e+05,
  tmax = 1000,
  varSP = FALSE,
  spLim = c(-75, 75),
  varDR = FALSE,
  drShape = 3,
  drLim = c(0.1, 0.7),
  rtMax = 5000,
  fullData = FALSE,
  nTrlData = 5,
  nDelta = 9,
  pDelta = vector(),
  nCAF = 5,
  printInputArgs = TRUE,
  printResults = TRUE,
  setSeed = FALSE
)
}
\arguments{
\item{amp}{amplitude of automatic activation}

\item{tau}{time to peak automatic activation}

\item{drc}{drift rate of controlled processes}

\item{bnds}{+- response criterion}

\item{resMean}{mean of non-decisional component}

\item{resSD}{standard deviation of non-decisional component}

\item{aaShape}{shape parameter of automatic activation}

\item{spShape}{shape parameter of starting point}

\item{sigm}{diffusion constant}

\item{nTrl}{number of trials}

\item{tmax}{number of time points per trial}

\item{varSP}{true/false variable starting point}

\item{spLim}{limit range of distribution of starting point}

\item{varDR}{true/false variable drift rate NB. In DMC, drift rate across trials is always constant.}

\item{drShape}{shape parameter of drift rate}

\item{drLim}{limit range of distribution of drift rate}

\item{rtMax}{limit on simulated RT (decision + non-decisional component)}

\item{fullData}{TRUE/FALSE (Default: FALSE)}

\item{nTrlData}{Number of trials to plot}

\item{nDelta}{Number of delta bins}

\item{pDelta}{Alternative to nDelta by directly specifying required percentile values}

\item{nCAF}{Number of CAF bins}

\item{printInputArgs}{TRUE/FALSE}

\item{printResults}{TRUE/FALSE}

\item{setSeed}{TRUE/FALSE}
}
\value{
dmcsim

The function returns a list with the relevant results from the simulation. The list
is accessed with obj$name with the the following:
\item{obj$means}{Condition means for reaction time and error rate}
\item{obj$caf}{Accuracy per bin for compatible and incompatible trials}
\item{obj$delta}{Mean RT and compatibility effect per bin}
\item{obj$sim}{Individual trial data points (reaction times/error) and activation vectors from simulation}
\item{obj$trials}{Example individual trial timecourse for n compatible and incompatible trials}
\item{obj$prms}{The input parameters used in the simulation}
}
\description{
DMC model simulation detailed in  Ulrich, R., Schroeter, H., Leuthold, H., & Birngruber, T. (2015).
Automatic and controlled stimulus processing in conflict tasks: Superimposed diffusion processes and delta functions.
Cognitive Psychology, 78, 148-174. This function is essentially a wrapper around the c++ function runDMC
}
\examples{
\donttest{
# Example 1
dmc <- dmcSim(fullData = TRUE)  # full data only required for activation plot (top left)
plot(dmc)
dmc <- dmcSim() # faster
plot(dmc)

# Example 2
dmc <- dmcSim(tau = 130)
plot(dmc)

# Example 3
dmc <- dmcSim(tau = 90)
plot(dmc)

# Example 4
dmc <- dmcSim(varSP = TRUE)
plot(dmc, "delta")

# Example 5
dmc <- dmcSim(tau = 130, varDR = TRUE)
plot(dmc, "caf")

# Example 6
dmc <- dmcSim(nDelta = 10, nCAF = 10)
plot(dmc)
}

}
