% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DMR.R
\name{predict.DMR}
\alias{predict.DMR}
\title{predict.DMR}
\usage{
\method{predict}{DMR}(
  object,
  newx,
  df = NULL,
  type = "link",
  unknown.factor.levels = "error",
  ...
)
}
\arguments{
\item{object}{Fitted \code{DMR} object.}

\item{newx}{Data frame of new values for \code{X} at which predictions are to be made. The intercept column should NOT be passed in a call to \code{predict}.}

\item{df}{Number of parameters in the model for which predictions are required. Default is the entire sequence of models for df=1 to df=p.}

\item{type}{One of: \code{"link"}, \code{"response"}, \code{"class"}. For \code{family="gaussian"} for all values of \code{type} it gives the fitted values. For \code{family="binomial"} and \code{type="link"} it returns the linear predictors, for \code{type="response"} it returns the fitted probabilities and for \code{type="class"} it produces the class labels corresponding to the maximum probability.}

\item{unknown.factor.levels}{The way of handling factor levels in test data not seen while training a model. One of \code{"error"} (the default - throwing an error) or \code{"NA"} (returning \code{NA} in place of legitimate value for problematic rows).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector or matrix of predictions.
}
\description{
Makes predictions from a \code{DMR} object.
}
\details{
Similar to other \code{predict} methods, this function predicts fitted values from a fitted \code{DMR} object.
}
\examples{
data(miete)
ytr <- miete[1:1500,1]
Xtr <- miete[1:1500,-1]
Xte <- miete[1501:2053,-1]
m <- DMR(Xtr, ytr)
ypr <- predict(m, newx = Xte, df = 11)
}
