% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustDODR.R
\name{robustDODR}
\alias{robustDODR}
\title{Asymmetric variant of Chow method applied on harmonic regression}
\usage{
robustDODR(val1, val2, times1, times2, period, norm = TRUE)
}
\arguments{
\item{val1}{matrix: data for values in first set. One column per
sample, one row per time point}

\item{val2}{matrix: data for values in second set. One column per
sample, one row per time point}

\item{times1}{vector: times of first set.}

\item{times2}{vector: times of second set.}

\item{period}{numeric: period of the oscillations. Same unit as the
time points in times1 and times2}

\item{norm}{boolean: whether to normalize the time series (division by mean),
prior to the analysis.}
}
\value{
data frame with following columns:
\itemize{
\item{p.value: }{P-value for difference between the two time series}
\item{F: }{F score from the underlying \code{\link[Rfit]{drop.test}} test}
\item{diff: }{Measure for the difference between the two fits}
}
}
\description{
Asymmetric variant of Chow method applied on harmonic regression
}
\details{
This test uses a robust Fitting drop test to test for differences
between two time series.
Therefore the time series are fitted to sine curves with a
fixed period length and free phase and amplitude. In one case phase and
amplitude have two be the same for both series, in the other case phase
and amplitude could differ for the two series.
}

