% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_compare.R
\name{time_compare}
\alias{time_compare}
\title{time_compare helper function}
\usage{
time_compare(rv, logfile_dir, headless = FALSE)
}
\arguments{
\item{rv}{A list object. Internal list simulating Shiny's
'reactive values'.}

\item{logfile_dir}{The absolute path to folder where the logfile
will be stored default(\code{tempdir()}).}

\item{headless}{A boolean (default: FALSE). Indicating, if the function is
run only in the console (headless = TRUE) or on a GUI frontend
(headless = FALSE).}
}
\value{
a list of time-compare results for each analyzed element.
For every element, there are three dataframes available. The first dataframe
(result_table), presents an overview table that displays the counts for each
timestamp. The other two dataframes (suspect_data_source and
suspect_data_target), contain all the data associated with the identified
timestamps found in the source or target data.
}
\description{
Internal function to calculate differences
between source and target based on a timestamp comparison. It can help to
identify potential missing resources.
}
\examples{
 \donttest{# runtime ~ 5 sec.
utils_path <- system.file(
  "demo_data/utilities/",
  package = "DQAstats"
)
mdr_filename <- "mdr_example_data.csv"
rv <- list()
rv$mdr <- read_mdr(
  utils_path = utils_path,
  mdr_filename <- mdr_filename
)

source_system_name <- "exampleCSV_source"
target_system_name <- "exampleCSV_target"

rv <- c(rv, create_helper_vars(
  mdr = rv$mdr,
  source_db = source_system_name,
  target_db = target_system_name
))
# save source/target vars
rv$source$system_name <- source_system_name
rv$target$system_name <- target_system_name
rv$source$system_type <- "csv"
rv$target$system_type <- "csv"

rv$log$logfile_dir <- tempdir()

# set headless (without GUI, progressbars, etc.)
rv$headless <- TRUE

# set configs
demo_files <- system.file("demo_data", package = "DQAstats")
Sys.setenv("EXAMPLECSV_SOURCE_PATH" = demo_files)
Sys.setenv("EXAMPLECSV_TARGET_PATH" = demo_files)

# get configs
rv$source$settings <- DIZutils::get_config_env(
  system_name = rv$source$system_name,
  logfile_dir = rv$log$logfile_dir,
  headless = rv$headless
)
rv$target$settings <- DIZutils::get_config_env(
  system_name = tolower(rv$target$system_name),
  logfile_dir = rv$log$logfile_dir,
  headless = rv$headless
)

# set start_time (e.g. when clicking the 'Load Data'-button in shiny
rv$start_time <- format(Sys.time(), usetz = TRUE, tz = "CET")

# define restricting date
rv$restricting_date$use_it <- FALSE

# load source data
tempdat <- data_loading(
  rv = rv,
  system = rv$source,
  keys_to_test = rv$keys_source
)
rv$data_source <- tempdat$outdata

# load target data
tempdat <- data_loading(
  rv = rv,
  system = rv$target,
  keys_to_test = rv$keys_target
)
rv$data_target <- tempdat$outdata

# time_compare
time_compare_results <- time_compare(
  rv = rv,
  logfile_dir = rv$log$logfile_dir,
  headless = rv$headless
)

}

}
