% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimaldrugs.R
\name{optimaldrugs}
\alias{optimaldrugs}
\title{Identifying the optimal drugs}
\usage{
optimaldrugs(SubPathscore,Drug_Pscore_matrix,nperm=1000,cut='top',
                   topcut=20,pcut=0.05,weight=FALSE)
}
\arguments{
\item{SubPathscore}{A dataframe with three columns which are "SubPathID","Weighted-ES","Pvalue" (The result of function "getSubPathscore").}

\item{Drug_Pscore_matrix}{A matrix with n rows and m columns. n is the number of subpathways and m is the number of all drugs. The values in this matrix is weighted enrichmentscore of subpathways in every drug. The users could obtain this matrix from our example data.}

\item{nperm}{Number of random permutations (default: 1000).}

\item{cut}{There are two ways to select up-regulated and down-regulated subpathways. The up-regulated subpathways (down-regulated subpathways) is the top (bottom) subpathways of list in descending order of weighted enrichmentscore (weighted-ES) when cut="top". When cut="p",up-regulated subpathways and down-regulated subpathways is screened based on ES and pvalue in the results of GSEA.}

\item{topcut}{When cut="top", topcut represents the number of selected up-regulated subpathways or down-regulated subpathways.The topcut defaults to 20.}

\item{pcut}{When cut="p", pcut represents the threshold of statistical significance level for screen subpathways. The pcut defaults to 0.05.}

\item{weight}{A boolean value determines the method for calculating the drug-disease association score of the drug. "weight=FALSE"(default): Similar to "CMap" (Lamb et al., 2006), no weight is needed. "weight=TRUE": KS random walk statistic with individualized subpathway activity score as weight was used to calculate the drug-disease reverse association score.}
}
\value{
A dataframe with four columns which are "Drug"(drug names),"KS"(final drug-disease assciation score),"pvalue"(statistical significance),"FDR"(statistical significance after adjust).
}
\description{
Function "optimaldrugs" used to identify the optimal drugs for specific disease.
}
\examples{
##Obtain input data
#Weighted enrichmentscore of subpathways this function need were stored
#in packet "DRviaSPCNData". "DRviaSPCNData" has been uploaded to the
#github repository.Users can download and install through "install_github"
#function and set parameter url="hanjunwei-lab/DRviaSPCNData".
#After installing and loading package "DRviaSPCNData",
#users can use the following command to get the data.
#DrugPscoreMatrix<-Getlist('DrugPscoreMatrix')
DE2SubPathresult<-GetExample("DE2SubPathresult")
GEP<-GetExample("GEP")
label<-GetExample("label")
\donttest{
SubPathscore<-getSubpathscore(DE2SubPathresult=DE2SubPathresult,inexpData=GEP,Label=label)
#Run the function
Opdrugresult<-optimaldrugs(SubPathscore=SubPathscore,Drug_Pscore_matrix=DrugPscoreMatrix,
                          nperm=1000,cut='p',topcut=20,pcut=0.01,weight=FALSE)}
}
