% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_evolution.R
\name{simulate_evolution}
\alias{simulate_evolution}
\title{Stochastic simulation of a compartmental SIR-type model with wild-type and mutant strains and treatment}
\usage{
simulate_evolution(S0 = 1000, Iu0 = 1, It0 = 1, Ir0 = 1,
  tmax = 100, bu = 1/1000, bt = 1/1000, br = 1/1000, cu = 1/1000,
  ct = 1/100, f = 0, gu = 1, gt = 1, gr = 1, rngseed = 100)
}
\arguments{
\item{S0}{initial number of susceptible hosts}

\item{Iu0}{initial number of wild-type infected untreated hosts}

\item{It0}{initial number of wild-type infected treated hosts}

\item{Ir0}{initial number of resistant infected hosts}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{bu}{level/rate of infectiousness for hosts in the Iu compartment}

\item{bt}{level/rate of infectiousness for hosts in the It compartment}

\item{br}{level/rate of infectiousness for hosts in the Ir compartment}

\item{cu}{fraction of resistant mutant infections that an untreated host produces}

\item{ct}{fraction of resistant mutant infections that a treated host produces}

\item{f}{fraction of infected receiving treatment}

\item{gu}{rate at which a host leaves the Iu compartment, which
is the inverse of the average time spent in that compartment}

\item{gt}{rate at which a person leaves the It compartment}

\item{gr}{rate at which a person leaves the Ir compartment}

\item{rngseed}{seed for random number generator to allow reproducibility}
}
\value{
This function returns the simulation result as obtained from a call
  to the adaptivetau integrator in list form. The list element ts is a
  dataframe where the first column is "Time," and the remaining columns
  represent the evolution of the model parameters: the number of susceptibles,
  the number infected by the drug-sensitive strain and not on treatment, the number
  infected by the drug-sensitive strain and being treated, the number infected by
  the drug-resistant strain (treatment does not affect these), and the recovered
  (and therefore immune) individuals.
}
\description{
Simulation of a stochastic 2-strain SIR model with the following compartments:
Susceptibles (S), Infected with wild-type/sensitive and untreated (Iu),
Infected with wild-type and treated (It), infected with resistant (Ir), 
Recovered and Immune (R)
}
\details{
A compartmental ID model with several states/compartments
is simulated as a stochastic model using the adaptive tau algorithm as implemented by ssa.adaptivetau()
in the adaptivetau package. See the manual of this package for more details.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
the code will likely abort with an error message
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_evolution()
# To choose parameter values other than the standard one, specify them like such:
result <- simulate_evolution(S0 = 2000,  tmax = 200, bt = 1/100)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[ , "Time"],result$ts[ , "S"],xlab='Time',ylab='Number Susceptible',type='l')
# Consider also a case in which the fraction of resistant mutant infections that an
# untreated host produces is high, at 0.9.
result <- simulate_evolution(S0 = 2000, tmax = 200, bt = 1/100, cu = 0.9)
plot(result$ts[,"Time"], result$ts[,"S"], xlab ="Time", ylab = "Number Susceptible",type ="l")
}
\references{
See the manual for the adaptivetau package for details on the algorithm.
            The implemented model is loosely based on: Handel et al 2009 JTB 
           "Antiviral resistance and the control of pandemic influenza: The roles of
           stochasticity, evolution and model details"
}
\author{
Andreas Handel
}
